/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util;

import com.tripwire.common.time.Time;
import com.tripwire.common.util.StackTrace;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Dbg {
    public static final boolean TRACE = Boolean.getBoolean("com.tripwire.trace");
    public static final boolean VERBOSE = Boolean.getBoolean("com.tripwire.debug.verbose");
    public static final boolean TESTING = System.getProperty("unittests.test") != null;
    public static final boolean INTELLIJ_TESTING = Boolean.getBoolean("unittests.intellij");
    private static SimpleDateFormat ms_fmt = new SimpleDateFormat("[yyyyMMdd-HH:mm:ss.SSS]");

    public static void trace(String msg) {
        if (TRACE) {
            Dbg.writeln(System.out, msg);
        }
    }

    public static void trace(Throwable e) {
        if (TRACE) {
            Dbg.writeln(System.out, Dbg.toString(e));
        }
    }

    public static void trace(Object self, String msg) {
        if (TRACE) {
            Dbg.writeln(System.out, Dbg.toString(self, msg));
        }
    }

    public static void trace(Object self, Throwable e) {
        if (TRACE) {
            Dbg.writeln(System.out, Dbg.toString(self, e));
        }
    }

    protected static void write(PrintStream target, String msg) {
        if (VERBOSE) {
            target.print(Dbg.getVerbosePrefix() + msg);
        } else {
            target.print(msg);
        }
    }

    protected static void writeln(PrintStream target, String msg) {
        if (VERBOSE) {
            target.println(Dbg.getVerbosePrefix() + msg);
        } else {
            target.println(msg);
        }
        target.flush();
    }

    public static String getVerbosePrefix() {
        return '[' + Dbg.timeToString(Time.now()) + ',' + Thread.currentThread().getName() + "] ";
    }

    public static synchronized String timeToString(long time) {
        return ms_fmt.format(new Date(time));
    }

    private static String toString(Object o, Throwable e) {
        return (o != null ? Dbg.nameof(o) + '/' : "") + Dbg.toString(e);
    }

    private static String toString(Object o, String s) {
        return (o != null ? Dbg.nameof(o) + ": " : "") + s;
    }

    private static String toString(Throwable e) {
        return String.valueOf(e) + "\n" + StackTrace.asString(e);
    }

    private static String nameof(Object o) {
        return o instanceof Class ? ((Class)o).getName() : o.getClass().getName();
    }
}

