/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.collections;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CollectionTools {
    private static final boolean USE_TROVE;

    public static Map createMap() {
        return USE_TROVE ? new THashMap(20, 0.75f) : new HashMap(20);
    }

    public static Map createMap(int capacity) {
        return USE_TROVE ? new THashMap(capacity, 0.75f) : new HashMap((int)((float)capacity / 0.75f + 1.0f));
    }

    public static Map createMap(int capacity, float loadFactor) {
        return USE_TROVE ? new THashMap(capacity, loadFactor) : new HashMap(capacity, loadFactor);
    }

    public static Set createSet() {
        return USE_TROVE ? new THashSet(20, 0.75f) : new HashSet(20);
    }

    public static Set createSet(int size) {
        return USE_TROVE ? new THashSet(size, 0.75f) : new HashSet((int)((float)size / 0.75f + 1.0f));
    }

    public static Map compactMap(Map map) {
        if (map instanceof LinkedHashMap) {
            return new LinkedHashMap(map);
        }
        if (map instanceof HashMap) {
            return new HashMap(map);
        }
        ((THashMap)map).compact();
        return map;
    }

    public static Set compactSet(Set set) {
        if (set instanceof LinkedHashSet) {
            return new LinkedHashSet(set);
        }
        if (set instanceof HashSet) {
            return new HashSet(set);
        }
        ((THashSet)set).compact();
        return set;
    }

    static {
        String value = System.getProperty("tw.collection.useTrove");
        USE_TROVE = value == null || Boolean.getBoolean("tw.collection.useTrove");
    }
}

