/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.HostScsiDiskPartition;
import com.vmware.vim25.HostVmfsVolume;

public class HostVmfsVolumeCollector
extends AbstractVmwareCollector {
    public HostVmfsVolumeCollector() {
        super(HostVmfsVolume.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".HostVmfsVolume";
        if (o instanceof HostVmfsVolume) {
            String version;
            HostVmfsVolume hostVmfsVolume = (HostVmfsVolume)o;
            int blockSizeMb = hostVmfsVolume.getBlockSizeMb();
            this.doPut(curKey + ".BlockSizeMb", "" + blockSizeMb);
            HostScsiDiskPartition[] extents = hostVmfsVolume.getExtent();
            if (null != extents) {
                for (int ii = 0; ii < extents.length; ++ii) {
                    if (null == extents[ii]) continue;
                    this.doCollect(extents[ii], curKey + ".Extent" + ii);
                }
            }
            int majorVersion = hostVmfsVolume.getMajorVersion();
            this.doPut(curKey + ".MajorVersion", "" + majorVersion);
            int maxBlocks = hostVmfsVolume.getMaxBlocks();
            this.doPut(curKey + ".MaxBlocks", "" + maxBlocks);
            String uuid = hostVmfsVolume.getUuid();
            if (null != uuid) {
                this.doPut(curKey + ".Uuid", uuid);
            }
            if (null != (version = hostVmfsVolume.getVersion())) {
                this.doPut(curKey + ".Version", version);
            }
        }
    }
}

