/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.HostHostBusAdapter;
import com.vmware.vim25.HostMultipathInfo;
import com.vmware.vim25.HostScsiTopology;
import com.vmware.vim25.HostStorageDeviceInfo;
import com.vmware.vim25.ScsiLun;

public class HostStorageDeviceInfoCollector
extends AbstractVmwareCollector {
    public HostStorageDeviceInfoCollector() {
        super(HostStorageDeviceInfo.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".HostStorageDeviceInfo";
        if (o instanceof HostStorageDeviceInfo) {
            HostStorageDeviceInfo hostStorageDeviceInfo = (HostStorageDeviceInfo)o;
            HostHostBusAdapter[] hostBusAdapters = hostStorageDeviceInfo.getHostBusAdapter();
            if (null != hostBusAdapters) {
                for (int ii = 0; ii < hostBusAdapters.length; ++ii) {
                    if (null == hostBusAdapters[ii]) continue;
                    this.doCollect(hostBusAdapters[ii], curKey + ".HostBusAdapter" + ii);
                }
            }
            HostMultipathInfo multipathInfo = hostStorageDeviceInfo.getMultipathInfo();
            this.doCollect(multipathInfo, curKey);
            ScsiLun[] scsiLuns = hostStorageDeviceInfo.getScsiLun();
            if (null != scsiLuns) {
                for (int ii = 0; ii < scsiLuns.length; ++ii) {
                    if (null == scsiLuns[ii]) continue;
                    this.doCollect(scsiLuns[ii], curKey + ".ScsiLun" + ii);
                }
            }
            HostScsiTopology scsiTopology = hostStorageDeviceInfo.getScsiTopology();
            this.doCollect(scsiTopology, curKey);
            boolean softwareInternetScsiEnabled = hostStorageDeviceInfo.isSoftwareInternetScsiEnabled();
            this.doPut(curKey + ".SoftwareInternetScsiEnabled", "" + softwareInternetScsiEnabled);
        }
    }
}

