/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.HostDnsConfig;

public class HostDnsConfigCollector
extends AbstractVmwareCollector {
    public HostDnsConfigCollector() {
        super(HostDnsConfig.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".HostDnsConfig";
        if (o instanceof HostDnsConfig) {
            HostDnsConfig hostDnsConfig = (HostDnsConfig)o;
            String[] addresses = hostDnsConfig.getAddress();
            if (null != addresses) {
                for (int ii = 0; ii < addresses.length; ++ii) {
                    if (null == addresses[ii]) continue;
                    this.doPut(curKey + ".Address" + ii, addresses[ii]);
                }
            }
            String domainName = hostDnsConfig.getDomainName();
            this.doPut(curKey + ".DomainName", domainName);
            String hostName = hostDnsConfig.getHostName();
            this.doPut(curKey + ".HostName", hostName);
            String[] searchDomains = hostDnsConfig.getSearchDomain();
            if (null != searchDomains) {
                for (int ii = 0; ii < searchDomains.length; ++ii) {
                    if (null == searchDomains[ii]) continue;
                    this.doPut(curKey + ".SearchDomain" + ii, searchDomains[ii]);
                }
            }
            String virtualNicDevice = hostDnsConfig.getVirtualNicDevice();
            this.doPut(curKey + ".VirtualNicDevice", virtualNicDevice);
            boolean dhcp = hostDnsConfig.isDhcp();
            this.doPut(curKey + ".Dhcp", "" + dhcp);
        }
    }
}

