/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.HostCpuIdInfo;
import com.vmware.vim25.HostCpuPackage;

public class HostCpuPackageCollector
extends AbstractVmwareCollector {
    public HostCpuPackageCollector() {
        super(HostCpuPackage.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".HostCpuPackage";
        if (o instanceof HostCpuPackage) {
            HostCpuPackage hostCpuPackage = (HostCpuPackage)o;
            long busHz = hostCpuPackage.getBusHz();
            this.doPut(curKey + ".BusHz", "" + busHz);
            HostCpuIdInfo[] cpuFeatures = hostCpuPackage.getCpuFeature();
            if (null != cpuFeatures) {
                for (int ii = 0; ii < cpuFeatures.length; ++ii) {
                    if (null == cpuFeatures[ii]) continue;
                    this.doCollect(cpuFeatures[ii], curKey + ".cpuFeatures" + ii);
                }
            }
            String description = hostCpuPackage.getDescription();
            this.doPut(curKey + ".Description", description);
            long hz = hostCpuPackage.getHz();
            this.doPut(curKey + ".Hz", "" + hz);
            short index = hostCpuPackage.getIndex();
            this.doPut(curKey + ".Index", "" + index);
            short[] threadId = hostCpuPackage.getThreadId();
            if (null != cpuFeatures) {
                for (int ii = 0; ii < cpuFeatures.length; ++ii) {
                    this.doPut(curKey + ".ThreadId" + ii, "" + threadId[ii]);
                }
            }
            String vendor = hostCpuPackage.getVendor();
            this.doPut(curKey + ".Vendor", vendor);
        }
    }
}

