/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.ElementCache;
import com.tripwire.checker.accessor.soap.GlobalVmwareCollector;
import com.tripwire.checker.accessor.soap.VmwareCollector;
import com.tripwire.vmware.api.EsxServer;
import com.vmware.vim25.ManagedObjectReference;

public abstract class AbstractVmwareCollector
implements VmwareCollector {
    private Class m_targetClass;

    public AbstractVmwareCollector(Class clazz) {
        this.m_targetClass = clazz;
    }

    public String getTargetClass() {
        return this.m_targetClass.getName();
    }

    protected void doCollect(Object object, String parentKey) {
        GlobalVmwareCollector.getInstance().collect(object, parentKey);
    }

    protected void doPut(String name, String value) {
        if (null != name && null != value) {
            ElementCache.getInstance().put(name, value);
        }
    }

    protected void doPut(String name, Boolean value, Boolean defaultValue) {
        if (null != name) {
            Boolean pickValue = value == null ? defaultValue : value;
            ElementCache.getInstance().put(name, pickValue.toString());
        }
    }

    protected void doReference(ManagedObjectReference mor, String propertyName, String parentKey) {
        EsxServer esxServer = GlobalVmwareCollector.getInstance().getEsxServer();
        if (null != esxServer) {
            try {
                Object retrievedObject = esxServer.getDynamicProperty(mor, propertyName);
                this.doCollect(retrievedObject, parentKey);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

