/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

import com.mindbright.terminal.DisplayView;

public class VideoAttributeMap {
    protected int COLS;
    protected int TOTAL_ROWS;
    protected int defaultAttrib;
    protected int numAttribs;
    protected Attrib[] attribs;
    protected DisplayView display;

    public VideoAttributeMap(int n, int n2, int n3) {
        this.COLS = n2;
        this.TOTAL_ROWS = n;
        this.defaultAttrib = n3;
        this.attribs = new Attrib[1];
        this.numAttribs = 0;
    }

    public void setDisplay(DisplayView displayView) {
        this.display = displayView;
    }

    public boolean isAttrib(int n, int n2) {
        int n3 = this.getAttrib(n, n2);
        if (n3 < 0) {
            return false;
        }
        Attrib attrib = this.attribs[n3];
        return attrib.getRow() == n && attrib.getCol() == n2;
    }

    public int attribAt(int n, int n2) {
        int n3 = this.getAttrib(n, n2);
        if (n3 < 0) {
            return this.defaultAttrib;
        }
        return this.attribs[n3].getAttrib();
    }

    public void add(int n, int n2, int n3) {
        Attrib attrib;
        int n4;
        if (this.numAttribs + 1 > this.attribs.length) {
            Attrib[] attribArray = new Attrib[this.attribs.length * 2 + 1];
            System.arraycopy(this.attribs, 0, attribArray, 0, this.attribs.length);
            this.attribs = attribArray;
        }
        if ((n4 = this.getAttrib(n, n2)) >= 0 && this.attribs[n4].compareTo(n, n2) == 0) {
            this.attribs[n4].setAttrib(n3);
        } else {
            attrib = new Attrib(n, n2, n3);
            if (this.numAttribs == 0) {
                n4 = 0;
            } else {
                n4 = this.find(n, n2);
                System.arraycopy(this.attribs, n4, this.attribs, n4 + 1, this.attribs.length - 1 - n4);
            }
            this.attribs[n4] = attrib;
            ++this.numAttribs;
        }
        if (n4 + 1 == this.numAttribs) {
            this.makeDirty(n, n2, this.TOTAL_ROWS, this.COLS);
        } else {
            attrib = this.attribs[n4 + 1];
            this.makeDirty(n, n2, attrib.getRow() + 1, attrib.getCol());
        }
    }

    public void delete(int n, int n2) {
        if (!this.isAttrib(n, n2)) {
            return;
        }
        int n3 = this.getAttrib(n, n2);
        this.delete(n3);
    }

    protected void delete(int n) {
        int n2;
        int n3;
        int n4 = this.attribs[n].getRow();
        int n5 = this.attribs[n].getCol();
        if (this.numAttribs == 1 || n + 1 == this.numAttribs) {
            n3 = this.TOTAL_ROWS;
            n2 = this.COLS;
        } else {
            n3 = this.attribs[n + 1].getRow() + 1;
            n2 = this.attribs[n + 1].getCol() + 1;
            System.arraycopy(this.attribs, n + 1, this.attribs, n, this.numAttribs - n - 1);
        }
        --this.numAttribs;
        this.makeDirty(n4, n5, n3, n2);
    }

    public void setDefault(int n) {
        this.defaultAttrib = n;
        if (this.numAttribs == 0) {
            this.makeDirty(0, 0, this.TOTAL_ROWS, this.COLS);
            return;
        }
        Attrib attrib = this.attribs[0];
        if (attrib.getRow() == 0 && attrib.getCol() == 0) {
            return;
        }
        this.makeDirty(0, 0, attrib.getRow() + 1, attrib.getCol() + 1);
    }

    public void insertChars(int n, int n2, int n3) {
        int n4 = this.getAttrib(n, n2);
        if (n4 < 0) {
            return;
        }
        if (this.attribs[n4].compareTo(n, n2) < 0) {
            ++n4;
        }
        int n5 = n;
        int n6 = -1;
        int n7 = n + 1;
        int n8 = -1;
        while (n4 < this.numAttribs && this.attribs[n4].compareTo(n, this.COLS) < 0) {
            if (n6 == -1) {
                n6 = this.attribs[n4].getCol();
            }
            this.attribs[n4].incCol(n3);
            if (this.attribs[n4].compareTo(n, this.COLS) >= 0) {
                this.delete(n4);
                n8 = this.COLS;
                continue;
            }
            n8 = this.attribs[n4].getCol();
            ++n4;
        }
        if (n6 != -1) {
            this.makeDirty(n5, n6, n7, n8);
        }
    }

    public void deleteChars(int n, int n2, int n3) {
        int n4 = this.getAttrib(n, this.COLS - 1);
        if (n4 < 0) {
            return;
        }
        int n5 = n;
        int n6 = -1;
        int n7 = n + 1;
        int n8 = -1;
        while (n4 >= 0 && this.attribs[n4].compareTo(n, n2) >= 0) {
            if (n8 == -1) {
                n8 = this.attribs[n4].getCol() + 1;
            }
            this.attribs[n4].decCol(n3);
            if (this.attribs[n4].compareTo(n, n2) < 0) {
                this.attribs[n4].incCol(n3);
                n6 = this.attribs[n4].getCol();
                this.delete(n4);
            } else {
                n6 = this.attribs[n4].getCol();
            }
            --n4;
        }
        if (n6 < n2) {
            n6 = n2;
        }
        if (n8 != -1) {
            this.makeDirty(n5, n6, n7, n8);
        }
    }

    public void clear(int n, int n2, int n3) {
        int n4 = this.getAttrib(n, n3);
        if (n4 < 0) {
            return;
        }
        while (n4 >= 0 && this.attribs[n4].compareTo(n, n2) >= 0) {
            this.delete(n4);
            --n4;
        }
    }

    public void clearLine(int n) {
        this.clear(n, 0, this.COLS - 1);
    }

    public void insertLine(int n) {
        int n2 = this.getAttrib(n, 0);
        if (n2 < 0) {
            if (this.numAttribs == 0) {
                return;
            }
            n2 = 0;
        }
        if (this.attribs[n2].compareTo(n, 0) < 0) {
            ++n2;
        }
        while (n2 < this.numAttribs) {
            this.attribs[n2].incRow(1);
            if (this.attribs[n2].compareTo(this.TOTAL_ROWS, 0) >= 0) {
                this.delete(n2);
                continue;
            }
            ++n2;
        }
        this.makeDirty(n, 0, this.TOTAL_ROWS, this.COLS);
    }

    public void deleteLine(int n) {
        int n2 = this.getAttrib(n, 0);
        if (n2 < 0) {
            if (this.numAttribs == 0) {
                return;
            }
            n2 = 0;
        }
        if (this.attribs[n2].compareTo(n, 0) < 0) {
            ++n2;
        }
        while (n2 < this.numAttribs) {
            this.attribs[n2].decRow(1);
            if (this.attribs[n2].compareTo(n, 0) < 0) {
                this.attribs[n2].incRow(1);
                this.delete(n2);
                continue;
            }
            ++n2;
        }
        this.makeDirty(n, 0, this.TOTAL_ROWS, this.COLS);
    }

    public void resize(int n, int n2) {
        int n3 = 0;
        while (n3 < this.numAttribs) {
            if (this.attribs[n3].getCol() >= n2) {
                this.delete(n3);
                continue;
            }
            if (this.attribs[n3].getRow() >= n) {
                this.delete(n3);
                continue;
            }
            ++n3;
        }
        this.COLS = n2;
        this.TOTAL_ROWS = n;
    }

    public int[] getAttribsAt(int n, int n2) {
        int[] nArray = new int[this.COLS];
        int n3 = 0;
        int n4 = this.defaultAttrib;
        int n5 = this.getAttrib(n + n2, 0);
        if (n5 < 0) {
            n5 = -1;
        } else if (this.attribs[n5].compareTo(n, 0) >= 0) {
            n4 = this.attribs[n5].getAttrib();
        }
        n5 = this.nextAttrib(n5, n + n2);
        int n6 = n5 < 0 ? this.COLS : this.attribs[n5].getCol();
        while (n3 < this.COLS) {
            if (n3 < n6) {
                nArray[n3] = n4;
                ++n3;
                continue;
            }
            n4 = this.attribs[n5].getAttrib();
            if ((n5 = this.nextAttrib(n5, n + n2)) < 0) {
                n6 = this.COLS;
                continue;
            }
            n6 = this.attribs[n5].getCol();
        }
        return nArray;
    }

    protected int nextAttrib(int n, int n2) {
        int n3 = -1;
        n3 = ++n < this.numAttribs ? (n2 != this.attribs[n].getRow() ? -1 : n) : -1;
        return n3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.numAttribs; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.attribs[i].toString());
        }
        return stringBuffer.toString();
    }

    protected int getAttrib(int n, int n2) {
        if (this.numAttribs == 0) {
            return -1;
        }
        int n3 = this.find(n, n2);
        if (n3 == this.numAttribs) {
            --n3;
        }
        if (this.attribs[n3].compareTo(n, n2) > 0) {
            --n3;
        }
        return n3;
    }

    protected int find(int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = this.numAttribs - 1;
        int n6 = 0;
        while (n4 <= n5) {
            n6 = (n4 + n5) / 2;
            n3 = this.attribs[n6].compareTo(n, n2);
            if (n3 < 0) {
                n4 = n6 + 1;
                continue;
            }
            if (n3 <= 0) break;
            n5 = n6 - 1;
        }
        n3 = n6;
        if (n4 > n6) {
            n3 = n4;
        }
        return n3;
    }

    protected void makeDirty(int n, int n2, int n3, int n4) {
        if (this.display != null) {
            this.display.updateDirtyArea(n, n2, n3, n4);
        }
    }

    protected class Attrib {
        private int row;
        private int col;
        private int attrib;

        Attrib(int n, int n2, int n3) {
            this.row = n;
            this.col = n2;
            this.attrib = n3;
        }

        int getRow() {
            return this.row;
        }

        void incRow(int n) {
            this.row += n;
        }

        void decRow(int n) {
            this.row -= n;
        }

        int getCol() {
            return this.col;
        }

        void incCol(int n) {
            this.col += n;
        }

        void decCol(int n) {
            this.col -= n;
        }

        int getAttrib() {
            return this.attrib;
        }

        void setAttrib(int n) {
            this.attrib = n;
        }

        int compareTo(int n, int n2) {
            if (this.row < n) {
                return -1;
            }
            if (this.row == n) {
                if (this.col < n2) {
                    return -1;
                }
                if (this.col == n2) {
                    return 0;
                }
            }
            return 1;
        }

        public String toString() {
            return String.valueOf(this.row) + "," + this.col + "=" + this.attrib;
        }
    }
}

