/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

import com.mindbright.terminal.DisplayView;
import com.mindbright.terminal.tandem6530.Terminal6530Callback;

class StatusLine {
    private static int LINE_LENGTH = 80;
    private static int MESSAGE_LENGTH = 64;
    private static int STATUS_LENGTH = 13;
    private static int ERROR_LENGTH = 79;
    private char[] statusLine = new char[LINE_LENGTH];
    private char[] errorLine = new char[LINE_LENGTH];
    private int[] attribLine = new int[LINE_LENGTH];
    private boolean errorSet = false;
    private DisplayView display;
    private Terminal6530Callback termCallback;

    StatusLine(Terminal6530Callback terminal6530Callback, int n) {
        for (int i = 0; i < LINE_LENGTH; ++i) {
            this.attribLine[i] = n;
        }
        this.clearLine(this.statusLine, 0, LINE_LENGTH);
        this.clearLine(this.errorLine, 0, LINE_LENGTH);
        this.termCallback = terminal6530Callback;
    }

    private void notifyDisplay() {
        this.termCallback.statusLineUpdated();
    }

    private void clearLine(char[] cArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            cArray[i] = 32;
        }
    }

    private void copyString(String string, char[] cArray, int n, int n2) {
        char[] cArray2 = string.toCharArray();
        this.copyString(cArray2, cArray, n, n2);
    }

    private void copyString(char[] cArray, char[] cArray2, int n, int n2) {
        int n3 = cArray.length < n2 ? cArray.length : n2;
        this.clearLine(cArray2, n, n2);
        System.arraycopy(cArray, 0, cArray2, n, n3);
    }

    void setDisplay(DisplayView displayView) {
        this.display = displayView;
    }

    void setMessage(String string) {
        this.copyString(string, this.statusLine, 1, MESSAGE_LENGTH);
        this.notifyDisplay();
    }

    void setMessage(char[] cArray, char[] cArray2) {
        this.copyString(cArray, this.statusLine, 1, MESSAGE_LENGTH);
        this.notifyDisplay();
    }

    void setStatus(String string) {
        this.copyString(string, this.statusLine, 65, STATUS_LENGTH);
        this.notifyDisplay();
    }

    void setError(String string) {
        this.errorSet = true;
        this.copyString(string, this.errorLine, 1, ERROR_LENGTH);
        this.notifyDisplay();
    }

    void resetError() {
        this.errorSet = false;
        this.notifyDisplay();
    }

    char[] getChars() {
        if (this.errorSet) {
            return this.errorLine;
        }
        return this.statusLine;
    }

    int[] getAttribs() {
        return this.attribLine;
    }
}

