/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

import com.mindbright.terminal.tandem6530.AsciiCodes;
import com.mindbright.terminal.tandem6530.DataType;
import com.mindbright.terminal.tandem6530.Field;
import com.mindbright.terminal.tandem6530.FieldAttributes;
import com.mindbright.terminal.tandem6530.FieldMap;
import com.mindbright.terminal.tandem6530.Position;
import com.mindbright.terminal.tandem6530.ProtectBlockMode;

public class ProtectedScreen
implements AsciiCodes {
    protected ProtectBlockMode parent;
    protected FieldMap map;
    protected int ROWS;
    protected int COLS;
    protected Position cursor;
    protected Position buffer;
    protected Position HOME;
    protected Position END;
    protected FieldAttributes defaultField;

    public ProtectedScreen(int n, int n2, DataType dataType) {
        this(null, n, n2, dataType);
    }

    public ProtectedScreen(ProtectBlockMode protectBlockMode, int n, int n2, DataType dataType) {
        this.parent = protectBlockMode;
        this.ROWS = n;
        this.COLS = n2;
        this.defaultField = new FieldAttributes();
        this.defaultField.setProtect(true);
        this.map = new FieldMap(n, n2, this.defaultField, dataType);
        this.cursor = new Position(0, 0, true);
        this.buffer = new Position(0, 0, true);
        this.HOME = new Position(0, 0);
        this.END = new Position(this.ROWS - 1, this.COLS - 1);
    }

    public void reset() {
        this.map.reset(this.defaultField);
        this.cursor.set(this.HOME);
        this.buffer.set(this.HOME);
    }

    public void doBackspace() {
        if (!this.map.haveUnprotectedFields()) {
            return;
        }
        this.cursor.decCol(this.ROWS, this.COLS);
        if (this.map.getFieldAt(this.cursor).isProtected() || this.map.getFieldAt(this.cursor).getStart().equals(this.cursor)) {
            this.back();
        }
        this.updateCursorPosition();
    }

    public void doHTab() {
        if (!this.map.haveUnprotectedFields()) {
            return;
        }
        this.forward();
        this.updateCursorPosition();
    }

    public void doLineFeed() {
        if (!this.map.haveUnprotectedFields()) {
            return;
        }
        this.cursor.incRow(this.ROWS, this.COLS);
        if (this.map.getFieldAt(this.cursor).isProtected()) {
            this.forward();
        }
        this.updateCursorPosition();
    }

    public void doCarriageReturn() {
        if (!this.map.haveUnprotectedFields()) {
            return;
        }
        this.cursor.setCol(0);
        if (this.map.getFieldAt(this.cursor).isProtected()) {
            this.forward();
        }
        this.updateCursorPosition();
    }

    public void doBackTab() {
        if (!this.map.haveUnprotectedFields()) {
            return;
        }
        Field field = this.map.getFieldAt(this.cursor);
        Position position = new Position(field.getStart()).incCol(this.ROWS, this.COLS);
        if (position.lt(this.cursor)) {
            this.cursor.set(position);
        } else {
            this.back();
        }
        this.updateCursorPosition();
    }

    public void doCursorUp() {
        if (!this.map.haveUnprotectedFields()) {
            return;
        }
        this.cursor.decRow(this.ROWS, this.COLS);
        if (this.map.getFieldAt(this.cursor).isProtected()) {
            this.back();
        }
        this.updateCursorPosition();
    }

    public void doCursorDown() {
        if (!this.map.haveUnprotectedFields()) {
            return;
        }
        this.cursor.incRow(this.ROWS, this.COLS);
        if (this.map.getFieldAt(this.cursor).isProtected()) {
            this.forward();
        }
        this.updateCursorPosition();
    }

    public void doCursorRight() {
        if (!this.map.haveUnprotectedFields()) {
            return;
        }
        this.cursor.incCol(this.ROWS, this.COLS);
        if (this.map.getFieldAt(this.cursor).isProtected()) {
            this.forward();
        }
        this.updateCursorPosition();
    }

    public void doCursorHomeDown() {
        if (!this.map.haveUnprotectedFields()) {
            return;
        }
        this.back(this.END);
        this.updateCursorPosition();
    }

    public void doCursorHome() {
        if (!this.map.haveUnprotectedFields()) {
            return;
        }
        this.forward(this.HOME);
        this.updateCursorPosition();
    }

    public void cursorToLastCharInField() {
        if (!this.map.haveUnprotectedFields()) {
            return;
        }
        Field field = this.map.getFieldAt(this.cursor);
        Position position = new Position(field.getStart()).incCol(this.ROWS, this.COLS);
        int n = field.getContents().length();
        for (int i = 0; i < n; ++i) {
            this.cursor.incCol(this.ROWS, this.COLS);
        }
        this.updateCursorPosition();
    }

    public void cursorToNextUnprotected(int n) {
        if (!this.map.haveUnprotectedFields()) {
            return;
        }
        Position position = new Position(this.cursor);
        for (int i = 0; i < n; ++i) {
            position.incRow(this.ROWS, this.COLS);
        }
        position.setCol(0);
        Field field = this.getNextUnprotected(position);
        if (field == null) {
            field = this.getNextUnprotected(this.HOME);
        }
        position = new Position(field.getStart()).incCol(this.ROWS, this.COLS);
        this.cursor.set(position);
        this.updateCursorPosition();
    }

    public void setCursorAddress(int n, int n2) {
        Position position = new Position(n, n2);
        if (this.map.getFieldAt(position).isProtected()) {
            this.forward(position);
        } else {
            this.cursor.set(n, n2);
        }
        this.updateCursorPosition();
    }

    public Position getCursorAddress() {
        return this.cursor;
    }

    public void setBufferAddress(int n, int n2) {
        this.buffer.set(n, n2);
    }

    public Position getBufferAddress() {
        return this.buffer;
    }

    public void addField(FieldAttributes fieldAttributes) {
        this.addField(this.buffer, fieldAttributes);
        this.buffer.incCol(this.ROWS, this.COLS);
    }

    public void addField(Position position, FieldAttributes fieldAttributes) {
        boolean bl = this.map.haveUnprotectedFields();
        this.map.addField(position, fieldAttributes);
        if (!bl && this.map.haveUnprotectedFields()) {
            this.forward(this.HOME);
        }
    }

    public void doClearMemoryToSpaces(int n, int n2, int n3, int n4) {
        Position position = new Position(n, n2);
        Position position2 = new Position(n3, n4);
        this.map.clear(position, position2);
        if (this.map.getFieldAt(this.cursor).isProtected()) {
            this.forward();
            this.updateCursorPosition();
        }
        this.updateDirty(position, position2);
    }

    public void doEraseToEndOfPageOrMemory(boolean bl) {
        Position position = bl ? this.cursor : this.buffer;
        Field field = this.getNextUnprotected(position);
        while (field != null) {
            field.clearField();
            field = this.getNextUnprotected(field.getStart());
        }
    }

    public void doEraseToEndOfLineOrField(boolean bl) {
        Position position = bl ? this.cursor : this.buffer;
        Field field = this.map.getFieldAt(position);
        field.clearToEnd(position);
        this.updateDirty(position, field.getEnd());
    }

    public void doInsertLine() {
        this.map.insertRow(this.buffer.getRow());
        if (this.map.getFieldAt(this.cursor).isProtected()) {
            this.forward();
            this.updateCursorPosition();
        }
        this.updateDirty(new Position(this.buffer.getRow(), 0), this.END);
    }

    public void doDeleteLine() {
        this.map.deleteRow(this.buffer.getRow());
        if (this.map.getFieldAt(this.cursor).isProtected()) {
            this.forward();
            this.updateCursorPosition();
        }
        this.updateDirty(new Position(this.buffer.getRow(), 0), this.END);
    }

    public void doInsertCharacter(boolean bl) {
        Position position = bl ? this.cursor : this.buffer;
        Field field = this.map.getFieldAt(position);
        if (field.isProtected()) {
            return;
        }
        field.insertChar(position);
        this.updateDirty(position, field.getEnd());
    }

    public void doDeleteCharacter(boolean bl) {
        Position position = bl ? this.cursor : this.buffer;
        Field field = this.map.getFieldAt(position);
        if (field.isProtected()) {
            return;
        }
        field.deleteChar(position);
        this.updateDirty(position, field.getEnd());
    }

    public void doResetMoifiedDataTags() {
        Field field = this.getNextUnprotected(this.HOME);
        while (field != null) {
            field.resetMdt();
            field = this.getNextUnprotected(field.getStart());
        }
    }

    public void bufferWrite(char c) {
        Field field = this.map.getFieldAt(this.buffer);
        field.writeBufferChar(this.buffer, c);
        this.updateDirty(this.buffer, this.buffer);
        this.buffer.incCol(this.ROWS, this.COLS);
    }

    public void setAttribute(int n) {
        Field field = this.map.getFieldAt(this.buffer);
        field.setAttrib(this.buffer, n);
    }

    public boolean cursorWrite(char c) {
        return this.cursorWrite(c, false);
    }

    public boolean cursorWrite(char c, boolean bl) {
        Field field = this.map.getFieldAt(this.cursor);
        if (field.getStart().equals(this.cursor)) {
            return true;
        }
        boolean bl2 = field.writeCursorChar(this.cursor, c, bl);
        if (bl2) {
            if (bl) {
                this.updateDirty(this.cursor, field.getEnd());
            } else {
                this.updateDirty(this.cursor, this.cursor);
            }
            this.cursor.incCol(this.ROWS, this.COLS);
            if (this.map.getFieldAt(this.cursor) != field && field.hasAutoTab()) {
                field = this.getNextUnprotected(this.cursor);
                if (field == null) {
                    field = this.getNextUnprotected(this.HOME);
                }
                this.cursor = new Position(field.getStart()).incCol(this.ROWS, this.COLS);
            }
            this.updateCursorPosition();
        }
        return bl2;
    }

    protected void readField(StringBuffer stringBuffer, Field field) {
        Position position = new Position(field.getStart()).incCol(this.ROWS, this.COLS);
        stringBuffer.append('\u0011');
        stringBuffer.append((char)(31 + position.getRow() + 1));
        stringBuffer.append((char)(31 + position.getCol() + 1));
        stringBuffer.append(field.getContents());
    }

    protected String readWithAddress(Position position, Position position2, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        Field field = this.map.getFieldAt(position);
        Position position3 = new Position(field.getStart()).incCol(this.ROWS, this.COLS);
        if (position3.lt(position)) {
            field = this.getNextField(position);
        }
        while (field != null && field.getStart().le(position2)) {
            if (bl && !field.isProtected()) {
                this.readField(stringBuffer, field);
            } else if (bl2 || field.getMdt()) {
                this.readField(stringBuffer, field);
            }
            field = this.getNextField(field.getEnd());
        }
        stringBuffer.append('\u0004');
        return stringBuffer.toString();
    }

    public String readWholePageOrBuffer() {
        return this.readWithAddress(this.HOME, this.END, true, false);
    }

    public String readWithAddress(Position position, Position position2) {
        return this.readWithAddress(position, position2, false, false);
    }

    public String readWithAddressAll(Position position, Position position2) {
        return this.readWithAddress(position, position2, false, true);
    }

    public char[] getChars(int n) {
        char[] cArray = new char[this.COLS];
        int n2 = 0;
        Position position = new Position(n, 0);
        Field field = this.map.getFieldAt(position);
        char[] cArray2 = field.getChars(n);
        while (n2 < this.COLS) {
            System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
            if ((n2 += cArray2.length) >= this.COLS) break;
            position.set(field.getEnd()).incCol(this.ROWS, this.COLS);
            field = this.map.getFieldAt(position);
            cArray2 = field.getChars(n);
        }
        return cArray;
    }

    public int[] getAttribs(int n) {
        int[] nArray = new int[this.COLS];
        int n2 = 0;
        Position position = new Position(n, 0);
        Field field = this.map.getFieldAt(position);
        int[] nArray2 = field.getAttribs(n);
        while (n2 < this.COLS) {
            System.arraycopy(nArray2, 0, nArray, n2, nArray2.length);
            if ((n2 += nArray2.length) >= this.COLS) break;
            position.set(field.getEnd()).incCol(this.ROWS, this.COLS);
            field = this.map.getFieldAt(position);
            nArray2 = field.getAttribs(n);
        }
        return nArray;
    }

    protected void back() {
        this.back(this.cursor);
    }

    protected void back(Position position) {
        this.back(position, false);
    }

    protected void back(Position position, boolean bl) {
        if (!this.map.haveUnprotectedFields()) {
            return;
        }
        Field field = this.map.getFieldAt(position);
        if (field.isProtected()) {
            this.back(new Position(field.getStart(), true).decCol(this.ROWS, this.COLS), true);
            return;
        }
        Position position2 = new Position(field.getStart()).incCol(this.ROWS, this.COLS);
        if (!bl && position2.equals(this.cursor)) {
            this.back(new Position(field.getStart(), true).decCol(this.ROWS, this.COLS), true);
            return;
        }
        this.cursor.set(position2);
    }

    protected void forward() {
        this.forward(this.cursor);
    }

    protected void forward(Position position) {
        if (!this.map.haveUnprotectedFields()) {
            return;
        }
        Field field = this.getNextUnprotected(position);
        if (field == null) {
            field = this.getNextUnprotected(this.HOME);
        }
        this.cursor.set(field.getStart());
        this.cursor.incCol(this.ROWS, this.COLS);
    }

    public void updateCursorPosition() {
        if (this.parent != null) {
            this.parent.updateCursorPosition(this, this.cursor);
        }
    }

    protected void updateDirty(Position position, Position position2) {
        if (this.parent != null) {
            this.parent.updateDirty(this, position, position2);
        }
    }

    protected Field getNextField(Position position) {
        Field field = this.map.nextField(position);
        if (field.getEnd().equals(this.END)) {
            return null;
        }
        return field;
    }

    protected Field getNextUnprotected(Position position) {
        Field field;
        Field field2 = this.map.getFieldAt(position);
        if (field2 == (field = this.map.nextField(position))) {
            return null;
        }
        if (!field.isProtected()) {
            return field;
        }
        return this.getNextUnprotected(field.getEnd());
    }

    protected Field getPrevUnprotected(Position position) {
        Field field = this.map.prevField(position);
        if (!field.isProtected()) {
            return field;
        }
        if (field.getStart().equals(this.HOME)) {
            return null;
        }
        return this.getPrevUnprotected(field.getStart());
    }
}

