/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.sshcommon;

import com.isnetworks.ssh.FileBrowser;
import com.isnetworks.ssh.FileDisplayAWT;
import com.isnetworks.ssh.FileDisplayControl;
import com.isnetworks.ssh.FileListItem;
import com.mindbright.application.MindTermApp;
import com.mindbright.gui.AWTConvenience;
import com.mindbright.sshcommon.SSHChdirEventHandler;
import com.mindbright.sshcommon.SSHFileTransfer;
import com.mindbright.sshcommon.SSHFileTransferDialogControl;
import com.mindbright.sshcommon.SSHFileTransferFactory;
import com.mindbright.sshcommon.SSHFileTransferGUIThreadAWT;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class SSHFileTransferDialogAWT
extends Dialog
implements SSHFileTransferDialogControl,
ActionListener {
    private Button mUploadButton;
    private Button mDownloadButton;
    private Panel mFileDisplayPanel;
    private Panel mMainBottomSectionPanel;
    private Button closeButton;
    private FileDisplayAWT mLocalFileDisplay;
    private FileDisplayAWT mRemoteFileDisplay;
    private FileBrowser mRemoteFileBrowser;
    private FileBrowser mLocalFileBrowser;
    private MindTermApp client;
    private SSHFileTransferFactory fileXferFactory;
    private SSHChdirEventHandler chdirEventHandler = null;

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("close".equals(string)) {
            this.setVisible(false);
            this.mRemoteFileBrowser.disconnect();
            if (this.chdirEventHandler != null) {
                this.chdirEventHandler.chdir(this.mLocalFileDisplay.getFileSystemLocationLabelText());
            }
        } else {
            boolean bl = "toremote".equals(string);
            try {
                Object object;
                String string2;
                String string3;
                FileListItem[] fileListItemArray;
                String string4 = this.mLocalFileDisplay.getFileSystemLocationLabelText();
                String string5 = this.mRemoteFileDisplay.getFileSystemLocationLabelText();
                if (bl) {
                    fileListItemArray = this.mLocalFileDisplay.getSelectedFiles();
                    string3 = string4;
                    string2 = string5;
                } else {
                    fileListItemArray = this.mRemoteFileDisplay.getSelectedFiles();
                    string3 = string5;
                    string2 = string4;
                }
                String[] stringArray = new String[fileListItemArray.length];
                if (fileListItemArray.length == 0) {
                    throw new Exception("Please select file(s) to transfer");
                }
                for (int i = 0; i < fileListItemArray.length; ++i) {
                    stringArray[i] = string3 + fileListItemArray[i].getName();
                }
                String[] stringArray2 = new String[]{string2};
                if (!bl) {
                    object = stringArray2;
                    stringArray2 = stringArray;
                    stringArray = object;
                }
                object = this.fileXferFactory.create(this.client, new File(string4));
                new SSHFileTransferGUIThreadAWT(this.client, (SSHFileTransfer)object, stringArray, stringArray2, true, false, bl, this);
            }
            catch (Exception exception) {
                this.logError(exception);
            }
        }
    }

    public SSHFileTransferDialogAWT(String string, MindTermApp mindTermApp, SSHFileTransferFactory sSHFileTransferFactory) {
        super(mindTermApp.getParentFrame(), string, false);
        this.setFont(mindTermApp.getParentFrame().getFont());
        this.client = mindTermApp;
        this.fileXferFactory = sSHFileTransferFactory;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getFileDisplayPanel(), "Center");
        this.add((Component)this.getMainBottomSectionPanel(), "South");
        this.addWindowListener(new AWTConvenience.CloseAdapter(this.closeButton));
        this.pack();
    }

    public void setLocalFileBrowser(FileBrowser fileBrowser) {
        this.mLocalFileBrowser = fileBrowser;
    }

    public void setRemoteFileBrowser(FileBrowser fileBrowser) {
        this.mRemoteFileBrowser = fileBrowser;
    }

    private Panel getMainBottomSectionPanel() {
        if (this.mMainBottomSectionPanel == null) {
            this.mMainBottomSectionPanel = new Panel(new FlowLayout(2));
            this.closeButton = new Button("Close");
            this.closeButton.setActionCommand("close");
            this.closeButton.addActionListener(this);
            this.mMainBottomSectionPanel.add(this.closeButton);
        }
        return this.mMainBottomSectionPanel;
    }

    private Panel getFileDisplayPanel() {
        if (this.mFileDisplayPanel == null) {
            this.mFileDisplayPanel = new Panel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 1.0;
            this.mFileDisplayPanel.add((Component)((FileDisplayAWT)this.getLocalFileDisplay()), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 1.0;
            this.mFileDisplayPanel.add((Component)((FileDisplayAWT)this.getRemoteFileDisplay()), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.5;
            gridBagConstraints.insets = new Insets(0, 4, 2, 4);
            this.mFileDisplayPanel.add((Component)this.getDownloadButton(), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.5;
            gridBagConstraints.insets = new Insets(2, 4, 0, 4);
            this.mFileDisplayPanel.add((Component)this.getUploadButton(), gridBagConstraints);
        }
        return this.mFileDisplayPanel;
    }

    public FileDisplayControl getLocalFileDisplay() {
        if (this.mLocalFileDisplay == null) {
            this.mLocalFileDisplay = this.newFileDisplay("Local System");
        }
        return this.mLocalFileDisplay;
    }

    public FileDisplayControl getRemoteFileDisplay() {
        if (this.mRemoteFileDisplay == null) {
            this.mRemoteFileDisplay = this.newFileDisplay("Remote System");
        }
        return this.mRemoteFileDisplay;
    }

    private FileDisplayAWT newFileDisplay(String string) {
        return new FileDisplayAWT(this.client.getParentFrame(), string, this);
    }

    private Button getDownloadButton() {
        if (this.mDownloadButton == null) {
            this.mDownloadButton = new Button("<--");
            this.mDownloadButton.setActionCommand("tolocal");
            this.mDownloadButton.addActionListener(this);
        }
        return this.mDownloadButton;
    }

    private Button getUploadButton() {
        if (this.mUploadButton == null) {
            this.mUploadButton = new Button("-->");
            this.mUploadButton.setActionCommand("toremote");
            this.mUploadButton.addActionListener(this);
        }
        return this.mUploadButton;
    }

    public void refresh() {
        try {
            this.mRemoteFileBrowser.refresh();
            this.mLocalFileBrowser.refresh();
        }
        catch (Exception exception) {
            this.logError(exception);
        }
    }

    public void doShow() {
        this.setVisible(true);
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            super.setVisible(false);
            return;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width > 600 ? 600 : dimension.width;
        int n2 = dimension.height > 400 ? 400 : dimension.height;
        ((Component)this).setSize(n, n2);
        try {
            this.mRemoteFileBrowser.initialize();
            this.mLocalFileBrowser.initialize();
        }
        catch (Exception exception) {
            this.logError(exception);
        }
        super.setVisible(true);
    }

    public void logError(Exception exception) {
        this.client.alert(exception.getMessage());
    }

    public void setLocalChdirCallback(SSHChdirEventHandler sSHChdirEventHandler) {
        this.chdirEventHandler = sSHChdirEventHandler;
    }
}

