/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2DataBuffer;
import com.mindbright.ssh2.SSH2SFTP;
import com.mindbright.ssh2.SSH2SessionChannel;
import com.mindbright.util.Queue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class SSH2SFTPClient
extends SSH2SFTP {
    private static final int POOL_SIZE = 16;
    private SSH2Connection connection;
    private SSH2SessionChannel session;
    private Queue txQueue;
    private int id;
    private int version;
    private boolean isBlocking;
    private boolean isOpen;
    private volatile boolean transmitterIsRunning = false;
    private volatile boolean receiverIsRunning = false;
    private Hashtable replyLocks;
    private SSH2SFTP.SFTPPacket[] pktPool;
    private int pktPoolCnt;

    public SSH2SFTPClient(SSH2Connection sSH2Connection, boolean bl) throws SSH2SFTP.SFTPException {
        this.connection = sSH2Connection;
        this.id = 0;
        this.isBlocking = bl;
        this.restart();
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket();
        sFTPPacket.reset(1, 2);
        sFTPPacket.writeTo(this.session.getStdIn());
        sFTPPacket.reset();
        sFTPPacket.failsafeReadFrom(this.session.getStdOut());
        this.checkType(sFTPPacket, 2);
        this.version = sFTPPacket.readInt();
        this.releasePacket(sFTPPacket);
        if (!bl) {
            this.startNonblocking();
        }
    }

    public synchronized void terminate() {
        this.receiverIsRunning = false;
        this.isOpen = false;
        if (this.session != null) {
            this.session.close();
        }
        this.cancelAllAsync();
        if (this.transmitterIsRunning) {
            this.transmitterIsRunning = false;
            this.txQueue.setBlocking(false);
        }
        this.session = null;
        if (this.pktPool != null) {
            for (int i = 0; i < 16; ++i) {
                this.pktPool[i] = null;
            }
        }
        this.pktPoolCnt = 0;
    }

    public void restart() throws SSH2SFTP.SFTPException {
        this.terminate();
        this.session = this.connection.newSession();
        if (!this.session.doSubsystem("sftp")) {
            throw new SSH2SFTP.SFTPException("sftp subsystem couldn't be started on server");
        }
        this.isOpen = true;
        this.pktPool = new SSH2SFTP.SFTPPacket[16];
        this.pktPoolCnt = 16;
        for (int i = 0; i < 16; ++i) {
            this.pktPool[i] = new SSH2SFTP.SFTPPacket();
        }
    }

    public SSH2SFTP.FileHandle open(String string, int n, SSH2SFTP.FileAttributes fileAttributes) throws SSH2SFTP.SFTPException {
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(3);
        sFTPPacket.writeString(string);
        sFTPPacket.writeInt(n);
        sFTPPacket.writeAttrs(fileAttributes);
        sFTPPacket = this.transmitExpectReply(sFTPPacket, 102);
        SSH2SFTP.FileHandle fileHandle = new SSH2SFTP.FileHandle(string, sFTPPacket.readString(), false);
        this.releasePacket(sFTPPacket);
        return fileHandle;
    }

    public void close(SSH2SFTP.FileHandle fileHandle) throws SSH2SFTP.SFTPException {
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(4, fileHandle);
        sFTPPacket = this.transmitExpectReply(sFTPPacket, 101);
        this.releasePacket(sFTPPacket);
        fileHandle.asyncClose();
    }

    public void asyncWait(SSH2SFTP.FileHandle fileHandle) throws SSH2SFTP.SFTPException {
        fileHandle.asyncWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(SSH2SFTP.FileHandle fileHandle, long l, RandomAccessFile randomAccessFile, int n) throws SSH2SFTP.SFTPException, IOException {
        if (!fileHandle.isOpen()) {
            throw new SSH2SFTP.SFTPAsyncAbortException();
        }
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(5, fileHandle);
        sFTPPacket.writeLong(l);
        sFTPPacket.writeInt(n);
        if (this.isBlocking) {
            try {
                sFTPPacket = this.transmitExpectReply(sFTPPacket, 103);
                n = sFTPPacket.readInt();
                randomAccessFile.seek(l);
                randomAccessFile.write(sFTPPacket.getData(), sFTPPacket.getRPos(), n);
                int n2 = n;
                return n2;
            }
            catch (SSH2SFTP.SFTPEOFException sFTPEOFException) {
                int n3 = 0;
                return n3;
            }
            finally {
                if (sFTPPacket != null) {
                    this.releasePacket(sFTPPacket);
                }
            }
        }
        Integer n4 = new Integer(sFTPPacket.getId());
        ReadReplyLock readReplyLock = new ReadReplyLock(fileHandle, l, randomAccessFile, n);
        this.replyLocks.put(n4, readReplyLock);
        this.txQueue.putLast(sFTPPacket);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(SSH2SFTP.FileHandle fileHandle, long l, byte[] byArray, int n, int n2) throws SSH2SFTP.SFTPException {
        if (!fileHandle.isOpen()) {
            throw new SSH2SFTP.SFTPAsyncAbortException();
        }
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(5, fileHandle);
        sFTPPacket.writeLong(l);
        sFTPPacket.writeInt(n2);
        if (this.isBlocking) {
            try {
                sFTPPacket = this.transmitExpectReply(sFTPPacket, 103);
                int n3 = sFTPPacket.readString(byArray, n);
                return n3;
            }
            catch (SSH2SFTP.SFTPEOFException sFTPEOFException) {
                int n4 = 0;
                return n4;
            }
            finally {
                if (sFTPPacket != null) {
                    this.releasePacket(sFTPPacket);
                }
            }
        }
        if (!this.isOpen) {
            throw new SSH2SFTP.SFTPDisconnectException();
        }
        Integer n5 = new Integer(sFTPPacket.getId());
        ReadReplyLock readReplyLock = new ReadReplyLock(fileHandle, l, byArray, n, n2);
        this.replyLocks.put(n5, readReplyLock);
        this.txQueue.putLast(sFTPPacket);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readFully(SSH2SFTP.FileHandle fileHandle, OutputStream outputStream) throws SSH2SFTP.SFTPException, IOException {
        if (!fileHandle.isOpen()) {
            throw new SSH2SFTP.SFTPAsyncAbortException();
        }
        SSH2SFTP.FileAttributes fileAttributes = this.fstat(fileHandle);
        long l = fileAttributes.size;
        int n = 0;
        try {
            int n2;
            for (long i = 0L; i < l; i += (long)n2) {
                n2 = 32768L < l - i ? 32768 : (int)(l - i);
                SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(5, fileHandle);
                sFTPPacket.writeLong(i);
                sFTPPacket.writeInt(n2);
                if (this.isBlocking) {
                    try {
                        sFTPPacket = this.transmitExpectReply(sFTPPacket, 103);
                        n2 = sFTPPacket.readInt();
                        outputStream.write(sFTPPacket.getData(), sFTPPacket.getRPos(), n2);
                        continue;
                    }
                    finally {
                        if (sFTPPacket != null) {
                            this.releasePacket(sFTPPacket);
                        }
                    }
                }
                Integer n3 = new Integer(sFTPPacket.getId());
                ReadReplyLock readReplyLock = new ReadReplyLock(fileHandle, i, outputStream, n2);
                this.replyLocks.put(n3, readReplyLock);
                this.txQueue.putLast(sFTPPacket);
                if (this.isBlocking || ++n != 24) continue;
                n = 0;
                fileHandle.asyncWait(12);
            }
            if (!this.isBlocking) {
                fileHandle.asyncWait();
            }
        }
        finally {
            this.close(fileHandle);
        }
        return (int)fileAttributes.size;
    }

    protected void writeInternal(SSH2SFTP.FileHandle fileHandle, SSH2SFTP.SFTPPacket sFTPPacket, int n) throws SSH2SFTP.SFTPException {
        if (this.isBlocking) {
            sFTPPacket = this.transmitExpectReply(sFTPPacket, 101);
            this.releasePacket(sFTPPacket);
        } else {
            if (!this.isOpen) {
                throw new SSH2SFTP.SFTPDisconnectException();
            }
            Integer n2 = new Integer(sFTPPacket.getId());
            WriteReplyLock writeReplyLock = new WriteReplyLock(fileHandle, n);
            this.replyLocks.put(n2, writeReplyLock);
            this.txQueue.putLast(sFTPPacket);
        }
    }

    public void write(SSH2SFTP.FileHandle fileHandle, long l, byte[] byArray, int n, int n2) throws SSH2SFTP.SFTPException {
        if (!fileHandle.isOpen()) {
            throw new SSH2SFTP.SFTPAsyncAbortException();
        }
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(6, fileHandle);
        sFTPPacket.writeLong(l);
        sFTPPacket.writeString(byArray, n, n2);
        this.writeInternal(fileHandle, sFTPPacket, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeFully(SSH2SFTP.FileHandle fileHandle, InputStream inputStream) throws SSH2SFTP.SFTPException, IOException {
        if (!fileHandle.isOpen()) {
            throw new SSH2SFTP.SFTPAsyncAbortException();
        }
        int n = 0;
        long l = 0L;
        int n2 = 0;
        int n3 = 0;
        try {
            while (true) {
                SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(6, fileHandle);
                sFTPPacket.writeLong(l);
                n3 = sFTPPacket.getWPos();
                sFTPPacket.writeInt(0);
                int n4 = sFTPPacket.getMaxWriteSize();
                n4 = n4 > 32768 ? 32768 : n4;
                n = inputStream.read(sFTPPacket.getData(), sFTPPacket.getWPos(), n4);
                if (n <= 0) break;
                sFTPPacket.setWPos(n3);
                sFTPPacket.writeInt(n);
                sFTPPacket.setWPos(n3 + 4 + n);
                this.writeInternal(fileHandle, sFTPPacket, n);
                l += (long)n;
                if (!this.isBlocking && ++n2 == 24) {
                    n2 = 0;
                    fileHandle.asyncWait(12);
                }
                if (n2 % 6 != 1) continue;
                Thread.yield();
            }
            if (!this.isBlocking) {
                fileHandle.asyncWait();
            }
        }
        finally {
            this.close(fileHandle);
        }
        return l;
    }

    public SSH2SFTP.FileAttributes lstat(String string) throws SSH2SFTP.SFTPException {
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(7);
        sFTPPacket.writeString(string);
        return this.statInternal(sFTPPacket);
    }

    public SSH2SFTP.FileAttributes stat(String string) throws SSH2SFTP.SFTPException {
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(17);
        sFTPPacket.writeString(string);
        return this.statInternal(sFTPPacket);
    }

    public SSH2SFTP.FileAttributes fstat(SSH2SFTP.FileHandle fileHandle) throws SSH2SFTP.SFTPException {
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(8, fileHandle);
        return this.statInternal(sFTPPacket);
    }

    private SSH2SFTP.FileAttributes statInternal(SSH2SFTP.SFTPPacket sFTPPacket) throws SSH2SFTP.SFTPException {
        sFTPPacket = this.transmitExpectReply(sFTPPacket, 105);
        SSH2SFTP.FileAttributes fileAttributes = sFTPPacket.readAttrs();
        this.releasePacket(sFTPPacket);
        return fileAttributes;
    }

    public void setstat(String string, SSH2SFTP.FileAttributes fileAttributes) throws SSH2SFTP.SFTPException {
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(9);
        sFTPPacket.writeString(string);
        sFTPPacket.writeAttrs(fileAttributes);
        sFTPPacket = this.transmitExpectReply(sFTPPacket, 101);
        this.releasePacket(sFTPPacket);
    }

    public void fsetstat(SSH2SFTP.FileHandle fileHandle, SSH2SFTP.FileAttributes fileAttributes) throws SSH2SFTP.SFTPException {
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(10, fileHandle);
        sFTPPacket.writeAttrs(fileAttributes);
        sFTPPacket = this.transmitExpectReply(sFTPPacket, 101);
        this.releasePacket(sFTPPacket);
    }

    public SSH2SFTP.FileHandle opendir(String string) throws SSH2SFTP.SFTPException {
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(11);
        sFTPPacket.writeString(string);
        sFTPPacket = this.transmitExpectReply(sFTPPacket, 102);
        SSH2SFTP.FileHandle fileHandle = new SSH2SFTP.FileHandle(string, sFTPPacket.readString(), true);
        this.releasePacket(sFTPPacket);
        return fileHandle;
    }

    public SSH2SFTP.FileAttributes[] readdir(SSH2SFTP.FileHandle fileHandle) throws SSH2SFTP.SFTPException {
        int n;
        Object object;
        Vector<SSH2SFTP.FileAttributes> vector = new Vector<SSH2SFTP.FileAttributes>(256);
        SSH2SFTP.FileAttributes fileAttributes = null;
        try {
            while (true) {
                object = this.createPacket(12, fileHandle);
                n = ((SSH2DataBuffer)(object = this.transmitExpectReply((SSH2SFTP.SFTPPacket)object, 104))).readInt();
                if (n != 0) {
                    for (int i = 0; i < n; ++i) {
                        String string = ((SSH2DataBuffer)object).readJavaString();
                        String string2 = ((SSH2DataBuffer)object).readJavaString();
                        fileAttributes = ((SSH2SFTP.SFTPPacket)object).readAttrs();
                        fileAttributes.name = string;
                        fileAttributes.lname = string2;
                        fileAttributes.hasName = true;
                        vector.addElement(fileAttributes);
                    }
                    this.releasePacket((SSH2SFTP.SFTPPacket)object);
                    continue;
                }
                break;
            }
        }
        catch (SSH2SFTP.SFTPEOFException sFTPEOFException) {
            // empty catch block
        }
        object = new SSH2SFTP.FileAttributes[vector.size()];
        for (n = 0; n < ((SSH2SFTP.FileAttributes[])object).length; ++n) {
            object[n] = (SSH2SFTP.FileAttributes)vector.elementAt(n);
        }
        return object;
    }

    public void remove(String string) throws SSH2SFTP.SFTPException {
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(13);
        sFTPPacket.writeString(string);
        sFTPPacket = this.transmitExpectReply(sFTPPacket, 101);
        this.releasePacket(sFTPPacket);
    }

    public void rename(String string, String string2) throws SSH2SFTP.SFTPException {
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(18);
        sFTPPacket.writeString(string);
        sFTPPacket.writeString(string2);
        sFTPPacket = this.transmitExpectReply(sFTPPacket, 101);
        this.releasePacket(sFTPPacket);
    }

    public void mkdir(String string, SSH2SFTP.FileAttributes fileAttributes) throws SSH2SFTP.SFTPException {
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(14);
        sFTPPacket.writeString(string);
        sFTPPacket.writeAttrs(fileAttributes);
        sFTPPacket = this.transmitExpectReply(sFTPPacket, 101);
        this.releasePacket(sFTPPacket);
    }

    public void rmdir(String string) throws SSH2SFTP.SFTPException {
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(15);
        sFTPPacket.writeString(string);
        sFTPPacket = this.transmitExpectReply(sFTPPacket, 101);
        this.releasePacket(sFTPPacket);
    }

    public SSH2SFTP.FileAttributes realpath(String string) throws SSH2SFTP.SFTPException {
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(16);
        sFTPPacket.writeString(string);
        sFTPPacket = this.transmitExpectReply(sFTPPacket, 104);
        int n = sFTPPacket.readInt();
        String string2 = sFTPPacket.readJavaString();
        String string3 = sFTPPacket.readJavaString();
        SSH2SFTP.FileAttributes fileAttributes = sFTPPacket.readAttrs();
        fileAttributes.name = string2;
        fileAttributes.lname = string3;
        fileAttributes.hasName = true;
        this.releasePacket(sFTPPacket);
        return fileAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSH2SFTP.SFTPPacket transmitExpectReply(SSH2SFTP.SFTPPacket sFTPPacket, int n) throws SSH2SFTP.SFTPException {
        if (!this.isOpen) {
            throw new SSH2SFTP.SFTPDisconnectException();
        }
        if (this.isBlocking) {
            SSH2SFTPClient sSH2SFTPClient = this;
            synchronized (sSH2SFTPClient) {
                int n2 = sFTPPacket.getId();
                sFTPPacket.writeTo(this.session.getStdIn());
                sFTPPacket.reset();
                sFTPPacket.readFrom(this.session.getStdOut());
                if (n2 != sFTPPacket.readInt()) {
                    throw new SSH2SFTP.SFTPException("SFTP error, invalid packet id");
                }
                this.checkType(sFTPPacket, n);
                return sFTPPacket;
            }
        }
        Integer n3 = new Integer(sFTPPacket.getId());
        ReplyLock replyLock = new ReplyLock(n);
        this.replyLocks.put(n3, replyLock);
        this.txQueue.putLast(sFTPPacket);
        return replyLock.expect();
    }

    private void startNonblocking() {
        this.txQueue = new Queue(this.connection.getPreferences().getIntPreference("queue-depth"), this.connection.getPreferences().getIntPreference("queue-hiwater"));
        this.replyLocks = new Hashtable();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                SSH2SFTPClient.this.sftpTransmitLoop();
            }
        }, "SSH2SFTPTX");
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                SSH2SFTPClient.this.sftpReceiveLoop();
            }
        }, "SSH2SFTPRX");
        thread.setDaemon(true);
        thread2.setDaemon(true);
        this.transmitterIsRunning = true;
        thread.start();
        this.receiverIsRunning = true;
        thread2.start();
    }

    private void sftpTransmitLoop() {
        try {
            SSH2SFTP.SFTPPacket sFTPPacket;
            while (this.transmitterIsRunning && (sFTPPacket = (SSH2SFTP.SFTPPacket)this.txQueue.getFirst()) != null) {
                sFTPPacket.writeTo(this.session.getStdIn());
                this.releasePacket(sFTPPacket);
            }
        }
        catch (Throwable throwable) {
            this.connection.getLog().error("SSH2SFTPClient", "sftpTransmitLoop", "session was probably closed");
            this.terminate();
        }
        this.transmitterIsRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sftpReceiveLoop() {
        try {
            while (this.receiverIsRunning) {
                SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket();
                sFTPPacket.reset();
                sFTPPacket.readFrom(this.session.getStdOut());
                Integer n = new Integer(sFTPPacket.readInt());
                ReplyLock replyLock = (ReplyLock)this.replyLocks.remove(n);
                if (replyLock == null) {
                    this.connection.getLog().error("SSH2SFTPClient", "sftpReceiveLoop", "received unsent id: " + n);
                    this.connection.getLog().debug2("SSH2SFTPClient", "sftpReceiveLoop", "sftp packet: ", sFTPPacket.getData(), 0, sFTPPacket.getLength() + 5);
                    throw new SSH2SFTP.SFTPException("Invalid reply");
                }
                replyLock.received(sFTPPacket);
            }
        }
        catch (SSH2SFTP.SFTPDisconnectException sFTPDisconnectException) {
            this.connection.getLog().debug("SSH2SFTPClient", "sftpReceiveLoop", "session was closed");
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            this.connection.getLog().error("SSH2SFTPClient", "sftpReceiveLoop", "session was probably closed");
        }
        finally {
            if (this.receiverIsRunning) {
                this.terminate();
                this.receiverIsRunning = false;
            }
        }
    }

    private SSH2SFTP.SFTPPacket createPacket(int n, SSH2SFTP.FileHandle fileHandle) {
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket(n);
        sFTPPacket.writeString(fileHandle.getHandle());
        return sFTPPacket;
    }

    private SSH2SFTP.SFTPPacket createPacket(int n) {
        SSH2SFTP.SFTPPacket sFTPPacket = this.createPacket();
        sFTPPacket.reset(n, this.getNextId());
        return sFTPPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSH2SFTP.SFTPPacket createPacket() {
        SSH2SFTP.SFTPPacket[] sFTPPacketArray = this.pktPool;
        synchronized (this.pktPool) {
            SSH2SFTP.SFTPPacket sFTPPacket = this.pktPoolCnt == 0 ? new SSH2SFTP.SFTPPacket() : this.pktPool[--this.pktPoolCnt];
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return sFTPPacket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releasePacket(SSH2SFTP.SFTPPacket sFTPPacket) {
        SSH2SFTP.SFTPPacket[] sFTPPacketArray = this.pktPool;
        synchronized (this.pktPool) {
            if (this.pktPoolCnt < 16) {
                this.pktPool[this.pktPoolCnt++] = sFTPPacket;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void checkType(SSH2SFTP.SFTPPacket sFTPPacket, int n) throws SSH2SFTP.SFTPException {
        if (sFTPPacket.getType() == 101) {
            int n2 = sFTPPacket.readInt();
            if (n2 == 0) {
                return;
            }
            if (n2 == 1) {
                throw new SSH2SFTP.SFTPEOFException();
            }
            if (n2 == 2) {
                throw new SSH2SFTP.SFTPNoSuchFileException();
            }
            if (n2 == 3) {
                throw new SSH2SFTP.SFTPPermissionDeniedException();
            }
            if (n2 == 7) {
                throw new SSH2SFTP.SFTPDisconnectException();
            }
            throw new SSH2SFTP.SFTPException("Got error: " + n2);
        }
        if (sFTPPacket.getType() != n) {
            throw new SSH2SFTP.SFTPException("Got unexpected packet: " + sFTPPacket.getType());
        }
    }

    private void cancelAllAsync() {
        if (this.replyLocks == null) {
            return;
        }
        Enumeration enumeration = this.replyLocks.keys();
        while (enumeration.hasMoreElements()) {
            ReplyLock replyLock = (ReplyLock)this.replyLocks.remove(enumeration.nextElement());
            replyLock.cancel();
        }
    }

    private synchronized int getNextId() {
        return this.id++;
    }

    private class ReadReplyLock
    extends ReplyLock {
        private SSH2SFTP.FileHandle handle;
        private long fileOffset;
        private byte[] buf;
        private int off;
        private int len;
        private RandomAccessFile fileTarget;
        private OutputStream strmTarget;

        private ReadReplyLock(SSH2SFTP.FileHandle fileHandle, long l, int n) {
            super(103);
            this.handle = fileHandle;
            this.fileOffset = l;
            this.len = n;
            fileHandle.asyncStart(n);
        }

        protected ReadReplyLock(SSH2SFTP.FileHandle fileHandle, long l, OutputStream outputStream, int n) {
            this(fileHandle, l, n);
            this.strmTarget = outputStream;
        }

        protected ReadReplyLock(SSH2SFTP.FileHandle fileHandle, long l, RandomAccessFile randomAccessFile, int n) {
            this(fileHandle, l, n);
            this.fileTarget = randomAccessFile;
        }

        protected ReadReplyLock(SSH2SFTP.FileHandle fileHandle, long l, byte[] byArray, int n, int n2) {
            this(fileHandle, l, n2);
            this.buf = byArray;
            this.off = n;
        }

        protected synchronized void received(SSH2SFTP.SFTPPacket sFTPPacket) {
            try {
                int n;
                if (!this.handle.isOpen()) {
                    return;
                }
                SSH2SFTPClient.this.checkType(sFTPPacket, this.expectType);
                if (this.fileTarget != null) {
                    n = sFTPPacket.readInt();
                    this.fileTarget.seek(this.fileOffset);
                    this.fileTarget.write(sFTPPacket.getData(), sFTPPacket.getRPos(), n);
                } else if (this.strmTarget != null) {
                    if (this.handle.lastOffset != this.fileOffset) {
                        this.handle.asyncException(new SSH2SFTP.SFTPException("Out of order packets can't be handled yet!"));
                    }
                    n = sFTPPacket.readInt();
                    this.strmTarget.write(sFTPPacket.getData(), sFTPPacket.getRPos(), n);
                    this.handle.lastOffset = this.fileOffset + (long)n;
                } else {
                    n = sFTPPacket.readString(this.buf, this.off);
                }
                if (n < this.len) {
                    this.resend(sFTPPacket, n);
                } else {
                    this.handle.asyncEnd(this.len);
                    SSH2SFTPClient.this.releasePacket(sFTPPacket);
                }
            }
            catch (IOException iOException) {
                this.handle.asyncException(new SSH2SFTP.SFTPException(iOException.getMessage()));
            }
            catch (SSH2SFTP.SFTPEOFException sFTPEOFException) {
                this.handle.asyncReadEOF();
            }
            catch (SSH2SFTP.SFTPException sFTPException) {
                this.handle.asyncException(sFTPException);
            }
        }

        private void resend(SSH2SFTP.SFTPPacket sFTPPacket, int n) {
            int n2 = SSH2SFTPClient.this.getNextId();
            Integer n3 = new Integer(n2);
            this.fileOffset += (long)n;
            this.len -= n;
            this.off += n;
            sFTPPacket.reset(5, n2);
            sFTPPacket.writeString(this.handle.getHandle());
            sFTPPacket.writeLong(this.fileOffset);
            sFTPPacket.writeInt(this.len);
            SSH2SFTPClient.this.replyLocks.put(n3, this);
            SSH2SFTPClient.this.txQueue.putLast(sFTPPacket);
        }

        protected synchronized void cancel() {
            this.handle.asyncException(new SSH2SFTP.SFTPDisconnectException());
            this.notify();
        }
    }

    private class WriteReplyLock
    extends ReplyLock {
        private SSH2SFTP.FileHandle handle;
        private int len;

        protected WriteReplyLock(SSH2SFTP.FileHandle fileHandle, int n) {
            super(101);
            this.handle = fileHandle;
            this.len = n;
            fileHandle.asyncStart(n);
        }

        protected synchronized void received(SSH2SFTP.SFTPPacket sFTPPacket) {
            try {
                if (!this.handle.isOpen()) {
                    return;
                }
                SSH2SFTPClient.this.checkType(sFTPPacket, this.expectType);
                this.handle.asyncEnd(this.len);
            }
            catch (SSH2SFTP.SFTPException sFTPException) {
                this.handle.asyncException(sFTPException);
            }
            SSH2SFTPClient.this.releasePacket(sFTPPacket);
        }

        protected synchronized void cancel() {
            this.handle.asyncException(new SSH2SFTP.SFTPDisconnectException());
            this.notify();
        }
    }

    private class ReplyLock {
        protected int expectType;
        protected SSH2SFTP.SFTPPacket replyPkt;

        protected ReplyLock(int n) {
            this.expectType = n;
            this.replyPkt = null;
        }

        protected synchronized SSH2SFTP.SFTPPacket expect() throws SSH2SFTP.SFTPException {
            while (this.replyPkt == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            SSH2SFTPClient.this.checkType(this.replyPkt, this.expectType);
            return this.replyPkt;
        }

        protected synchronized void received(SSH2SFTP.SFTPPacket sFTPPacket) {
            this.replyPkt = sFTPPacket;
            this.notify();
        }

        protected synchronized void cancel() {
            this.replyPkt = SSH2SFTPClient.this.createPacket(101);
            this.replyPkt.writeInt(7);
            this.notify();
        }
    }
}

