/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2DataBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SSH2SFTP {
    private static final int DATA_BUFFER_SIZE = 34000;
    private static final int FAILSAFE_READ_BYTES = 1024;
    protected static final int SSH_FILEXFER_VERSION = 2;
    protected static final int SSH_FXP_INIT = 1;
    protected static final int SSH_FXP_VERSION = 2;
    protected static final int SSH_FXP_OPEN = 3;
    protected static final int SSH_FXP_CLOSE = 4;
    protected static final int SSH_FXP_READ = 5;
    protected static final int SSH_FXP_WRITE = 6;
    protected static final int SSH_FXP_LSTAT = 7;
    protected static final int SSH_FXP_FSTAT = 8;
    protected static final int SSH_FXP_SETSTAT = 9;
    protected static final int SSH_FXP_FSETSTAT = 10;
    protected static final int SSH_FXP_OPENDIR = 11;
    protected static final int SSH_FXP_READDIR = 12;
    protected static final int SSH_FXP_REMOVE = 13;
    protected static final int SSH_FXP_MKDIR = 14;
    protected static final int SSH_FXP_RMDIR = 15;
    protected static final int SSH_FXP_REALPATH = 16;
    protected static final int SSH_FXP_STAT = 17;
    protected static final int SSH_FXP_RENAME = 18;
    protected static final int SSH_FXP_STATUS = 101;
    protected static final int SSH_FXP_HANDLE = 102;
    protected static final int SSH_FXP_DATA = 103;
    protected static final int SSH_FXP_NAME = 104;
    protected static final int SSH_FXP_ATTRS = 105;
    protected static final int SSH_FXP_EXTENDED = 200;
    protected static final int SSH_FXP_EXTENDED_REPLY = 201;
    public static final int SSH_FX_OK = 0;
    public static final int SSH_FX_EOF = 1;
    public static final int SSH_FX_NO_SUCH_FILE = 2;
    public static final int SSH_FX_PERMISSION_DENIED = 3;
    public static final int SSH_FX_FAILURE = 4;
    public static final int SSH_FX_BAD_MESSAGE = 5;
    public static final int SSH_FX_NO_CONNECTION = 6;
    public static final int SSH_FX_CONNECTION_LOST = 7;
    public static final int SSH_FX_OP_UNSUPPORTED = 8;
    public static final int SSH_FXF_READ = 1;
    public static final int SSH_FXF_WRITE = 2;
    public static final int SSH_FXF_APPEND = 4;
    public static final int SSH_FXF_CREAT = 8;
    public static final int SSH_FXF_TRUNC = 16;
    public static final int SSH_FXF_EXCL = 32;
    protected static final int SSH_ATTR_SIZE = 1;
    protected static final int SSH_ATTR_UIDGID = 2;
    protected static final int SSH_ATTR_PERM = 4;
    protected static final int SSH_ATTR_MODTIME = 8;

    protected static final class SFTPPacket
    extends SSH2DataBuffer {
        private int type;
        private int id;
        private int len;

        public SFTPPacket() {
            super(34000);
        }

        public void reset(int n, int n2) {
            this.reset();
            this.writeInt(0);
            this.writeByte(n);
            this.writeInt(n2);
            this.type = n;
            this.id = n2;
        }

        public int getType() {
            return this.type;
        }

        public int getId() {
            return this.id;
        }

        public int getLength() {
            return this.len;
        }

        public void writeAttrs(FileAttributes fileAttributes) {
            this.writeInt((fileAttributes.hasSize ? 1 : 0) | (fileAttributes.hasUserGroup ? 2 : 0) | (fileAttributes.hasPermissions ? 4 : 0) | (fileAttributes.hasModTime ? 8 : 0));
            if (fileAttributes.hasSize) {
                this.writeLong(fileAttributes.size);
            }
            if (fileAttributes.hasUserGroup) {
                this.writeInt(fileAttributes.uid);
                this.writeInt(fileAttributes.gid);
            }
            if (fileAttributes.hasPermissions) {
                this.writeInt(fileAttributes.permissions);
            }
            if (fileAttributes.hasModTime) {
                this.writeInt(fileAttributes.atime);
                this.writeInt(fileAttributes.mtime);
            }
        }

        public FileAttributes readAttrs() {
            FileAttributes fileAttributes = new FileAttributes();
            int n = this.readInt();
            fileAttributes.hasSize = (n & 1) != 0;
            fileAttributes.hasUserGroup = (n & 2) != 0;
            fileAttributes.hasPermissions = (n & 4) != 0;
            boolean bl = fileAttributes.hasModTime = (n & 8) != 0;
            if (fileAttributes.hasSize) {
                fileAttributes.size = this.readLong();
            }
            if (fileAttributes.hasUserGroup) {
                fileAttributes.uid = this.readInt();
                fileAttributes.gid = this.readInt();
            }
            if (fileAttributes.hasPermissions) {
                fileAttributes.permissions = this.readInt();
            }
            if (fileAttributes.hasModTime) {
                fileAttributes.atime = this.readInt();
                fileAttributes.mtime = this.readInt();
            }
            return fileAttributes;
        }

        private void internalReadFrom(int n, InputStream inputStream) throws SFTPException {
            this.len = 5;
            try {
                while (n < this.len) {
                    int n2 = inputStream.read(this.data, n, this.len - n);
                    if (n2 == -1) {
                        throw new SFTPDisconnectException();
                    }
                    if ((n += n2) != 5) continue;
                    this.len = this.readInt() + 4;
                    this.type = this.readByte();
                }
            }
            catch (IOException iOException) {
                throw new SFTPException(iOException.getMessage());
            }
            this.len -= 5;
        }

        public void failsafeReadFrom(InputStream inputStream) throws SFTPException {
            byte[] byArray = new byte[2];
            try {
                if (2 != inputStream.read(byArray, 0, 2)) {
                    throw new SFTPDisconnectException();
                }
                for (int i = 0; i < 1024; ++i) {
                    if (byArray[0] == 0 && byArray[1] == 0) {
                        this.data[0] = byArray[0];
                        this.data[1] = byArray[1];
                        this.internalReadFrom(2, inputStream);
                        return;
                    }
                    byArray[0] = byArray[1];
                    if (1 == inputStream.read(byArray, 1, 1)) continue;
                    throw new SFTPDisconnectException();
                }
            }
            catch (IOException iOException) {
                throw new SFTPException(iOException.getMessage());
            }
            throw new SFTPException("Failed to find first packet");
        }

        public void readFrom(InputStream inputStream) throws SFTPException {
            this.internalReadFrom(0, inputStream);
        }

        public void writeTo(OutputStream outputStream) throws SFTPException {
            this.len = this.getWPos() - 5;
            this.setWPos(0);
            this.writeInt(this.len + 1);
            try {
                outputStream.write(this.data, 0, this.len + 5);
            }
            catch (IOException iOException) {
                throw new SFTPException(iOException.getMessage());
            }
        }
    }

    public static class SFTPAsyncAbortException
    extends SFTPException {
    }

    public static class SFTPDisconnectException
    extends SFTPException {
    }

    public static class SFTPPermissionDeniedException
    extends SFTPException {
    }

    public static class SFTPNoSuchFileException
    extends SFTPException {
    }

    public static class SFTPEOFException
    extends SFTPException {
    }

    public static class SFTPException
    extends Exception {
        public SFTPException() {
        }

        public SFTPException(String string) {
            super(string);
        }
    }

    public static final class FileAttributes {
        char[] types = new char[]{'p', 'c', 'd', 'b', '-', 'l', 's'};
        public static final int S_IFMT = 61440;
        public static final int S_IFSOCK = 49152;
        public static final int S_IFLNK = 40960;
        public static final int S_IFREG = 32768;
        public static final int S_IFBLK = 24576;
        public static final int S_IFDIR = 16384;
        public static final int S_IFCHR = 8192;
        public static final int S_IFIFO = 4096;
        public static final int S_ISUID = 2048;
        public static final int S_ISGID = 1024;
        public static final int S_IRUSR = 256;
        public static final int S_IWUSR = 128;
        public static final int S_IXUSR = 64;
        public static final int S_IRGRP = 32;
        public static final int S_IWGRP = 16;
        public static final int S_IXGRP = 8;
        public static final int S_IROTH = 4;
        public static final int S_IWOTH = 2;
        public static final int S_IXOTH = 1;
        public boolean hasName;
        public boolean hasSize;
        public boolean hasUserGroup;
        public boolean hasPermissions;
        public boolean hasModTime;
        public String name;
        public String lname;
        public long size;
        public int uid;
        public int gid;
        public int permissions;
        public int atime;
        public int mtime;

        public String toString() {
            return this.toString(this.hasName ? this.name : "<noname>");
        }

        private static String rightJustify(String string, int n) {
            String string2 = string;
            while (string2.length() < n) {
                string2 = " " + string2;
            }
            return string2;
        }

        public String toString(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.permString());
            stringBuffer.append("    1 ");
            stringBuffer.append(FileAttributes.rightJustify(Integer.toString(this.uid), 8));
            stringBuffer.append(" ");
            stringBuffer.append(FileAttributes.rightJustify(Integer.toString(this.gid), 8));
            stringBuffer.append(" ");
            stringBuffer.append(FileAttributes.rightJustify(Long.toString(this.size), 16));
            stringBuffer.append(" ");
            stringBuffer.append(this.modTimeString());
            stringBuffer.append(" ");
            stringBuffer.append(string);
            return stringBuffer.toString();
        }

        public String permString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.types[(this.permissions & 0xF000) >>> 13]);
            stringBuffer.append(this.rwxString(this.permissions, 6));
            stringBuffer.append(this.rwxString(this.permissions, 3));
            stringBuffer.append(this.rwxString(this.permissions, 0));
            return stringBuffer.toString();
        }

        public String modTimeString() {
            long l = (long)this.mtime * 1000L;
            long l2 = System.currentTimeMillis();
            SimpleDateFormat simpleDateFormat = l2 - l > 15552000000L ? new SimpleDateFormat("MMM dd  yyyy") : new SimpleDateFormat("MMM dd hh:mm");
            return simpleDateFormat.format(new Date(l));
        }

        private String rwxString(int n, int n2) {
            String string = (((n >>>= n2) & 4) != 0 ? "r" : "-") + ((n & 2) != 0 ? "w" : "-");
            string = n2 == 6 && this.isSUID() || n2 == 3 && this.isSGID() ? string + ((n & 1) != 0 ? "s" : "S") : string + ((n & 1) != 0 ? "x" : "-");
            return string;
        }

        public boolean isSocket() {
            return (this.permissions & 0xC000) == 49152;
        }

        public boolean isLink() {
            return (this.permissions & 0xA000) == 40960;
        }

        public boolean isFile() {
            return (this.permissions & 0x8000) == 32768;
        }

        public boolean isBlock() {
            return (this.permissions & 0x6000) == 24576;
        }

        public boolean isDirectory() {
            return (this.permissions & 0x4000) == 16384;
        }

        public boolean isCharacter() {
            return (this.permissions & 0x2000) == 8192;
        }

        public boolean isFifo() {
            return (this.permissions & 0x1000) == 4096;
        }

        public boolean isSUID() {
            return (this.permissions & 0x800) == 2048;
        }

        public boolean isSGID() {
            return (this.permissions & 0x400) == 1024;
        }
    }

    public static interface AsyncListener {
        public void progress(long var1);
    }

    public static final class FileHandle {
        private byte[] handle;
        private String name;
        private boolean isDirectory;
        private boolean isOpen;
        private boolean asyncEOF;
        private int asyncCnt;
        private int reqLeft;
        private SFTPException asyncException;
        private AsyncListener listener;
        protected volatile long lastOffset;

        protected FileHandle(String string, byte[] byArray, boolean bl) {
            this.name = string;
            this.handle = byArray;
            this.isDirectory = bl;
            this.isOpen = true;
            this.asyncCnt = 0;
            this.reqLeft = 0;
            this.asyncException = null;
            this.lastOffset = 0L;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        public String getName() {
            return this.name;
        }

        protected byte[] getHandle() {
            return this.handle;
        }

        public void addAsyncListener(AsyncListener asyncListener) {
            this.listener = asyncListener;
        }

        protected synchronized void asyncStart(int n) {
            ++this.asyncCnt;
        }

        protected synchronized void asyncEnd(int n) {
            --this.asyncCnt;
            if (this.asyncCnt <= this.reqLeft) {
                this.notifyAll();
            }
            if (this.listener != null) {
                this.listener.progress(n);
            }
        }

        protected synchronized void asyncReadEOF() {
            this.asyncEOF = true;
            this.asyncEnd(0);
        }

        protected synchronized void asyncException(SFTPException sFTPException) {
            this.asyncException = sFTPException;
            this.notifyAll();
        }

        protected synchronized void asyncClose() {
            if (this.asyncCnt > 0) {
                this.asyncException(new SFTPAsyncAbortException());
            }
            this.isOpen = false;
        }

        public synchronized boolean asyncWait() throws SFTPException {
            return this.asyncWait(0);
        }

        protected synchronized boolean asyncWait(int n) throws SFTPException {
            if (this.reqLeft < n) {
                this.reqLeft = n;
            }
            while (this.asyncCnt > n && this.asyncException == null && !this.asyncEOF) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.asyncException != null) {
                throw (SFTPException)this.asyncException.fillInStackTrace();
            }
            boolean bl = this.asyncEOF;
            this.asyncEOF = false;
            return bl;
        }

        public synchronized String toString() {
            return "FileHandle[name='" + this.name + "',isDir=" + this.isDirectory + ",isOpen=" + this.isOpen + ",asyncEOF=" + this.asyncEOF + ",asyncCnt=" + this.asyncCnt + ",reqLeft=" + this.reqLeft + ",asyncE=" + this.asyncException + ",asyncL=" + this.listener + "]";
        }
    }
}

