/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.jca.security.MessageDigest;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2KEXFailedException;
import com.mindbright.ssh2.SSH2Transport;
import com.mindbright.ssh2.SSH2TransportPDU;
import java.util.Hashtable;

public abstract class SSH2KeyExchanger {
    private static Hashtable algorithms = new Hashtable();

    protected SSH2KeyExchanger() {
    }

    public static SSH2KeyExchanger getInstance(String string) throws SSH2KEXFailedException {
        String string2 = (String)algorithms.get(string);
        SSH2KeyExchanger sSH2KeyExchanger = null;
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                sSH2KeyExchanger = (SSH2KeyExchanger)clazz.newInstance();
            }
            catch (Throwable throwable) {
                sSH2KeyExchanger = null;
            }
        }
        if (sSH2KeyExchanger == null) {
            throw new SSH2KEXFailedException("Unknown kex algorithm: " + string);
        }
        return sSH2KeyExchanger;
    }

    public abstract void init(SSH2Transport var1) throws SSH2Exception;

    public abstract void processKEXMethodPDU(SSH2TransportPDU var1) throws SSH2Exception;

    public abstract MessageDigest getExchangeHashAlgorithm();

    public abstract byte[] getSharedSecret_K();

    public abstract byte[] getExchangeHash_H();

    public abstract String getHostKeyAlgorithms();

    static {
        algorithms.put("diffie-hellman-group1-sha1", "com.mindbright.ssh2.SSH2KEXDHGroup1SHA1");
        algorithms.put("diffie-hellman-group14-sha1", "com.mindbright.ssh2.SSH2KEXDHGroup14SHA1");
        algorithms.put("diffie-hellman-group-exchange-sha1", "com.mindbright.ssh2.SSH2KEXDHGroupXSHA1");
    }
}

