/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.jca.security.KeyFactory;
import com.mindbright.jca.security.KeyPair;
import com.mindbright.jca.security.KeyPairGenerator;
import com.mindbright.jca.security.MessageDigest;
import com.mindbright.jce.crypto.KeyAgreement;
import com.mindbright.jce.crypto.interfaces.DHPrivateKey;
import com.mindbright.jce.crypto.interfaces.DHPublicKey;
import com.mindbright.jce.crypto.spec.DHParameterSpec;
import com.mindbright.jce.crypto.spec.DHPublicKeySpec;
import com.mindbright.security.publickey.ModPGroups;
import com.mindbright.ssh2.SSH2DataBuffer;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2FatalException;
import com.mindbright.ssh2.SSH2KEXFailedException;
import com.mindbright.ssh2.SSH2KeyExchanger;
import com.mindbright.ssh2.SSH2Transport;
import com.mindbright.ssh2.SSH2TransportPDU;
import java.math.BigInteger;

public class SSH2KEXDHGroup1SHA1
extends SSH2KeyExchanger {
    public static final BigInteger group1P = ModPGroups.oakleyGroup2P;
    public static final BigInteger group1G = ModPGroups.oakleyGroup2G;
    protected SSH2Transport transport;
    protected DHPublicKey dhPublicKey;
    protected DHPrivateKey dhPrivateKey;
    protected byte[] serverHostKey;
    protected BigInteger serverF;
    protected BigInteger clientE;
    protected byte[] sharedSecret_K;
    protected byte[] exchangeHash_H;
    protected MessageDigest sha1;

    public void init(SSH2Transport sSH2Transport) throws SSH2Exception {
        this.transport = sSH2Transport;
        this.sha1 = this.createHash();
        DHParameterSpec dHParameterSpec = new DHParameterSpec(group1P, group1G);
        this.generateDHKeyPair(dHParameterSpec);
        if (!sSH2Transport.isServer()) {
            this.sendDHINIT(30);
        }
    }

    public void processKEXMethodPDU(SSH2TransportPDU sSH2TransportPDU) throws SSH2Exception {
        if (sSH2TransportPDU.getType() == 31) {
            if (this.transport.isServer()) {
                throw new SSH2KEXFailedException("Unexpected KEXDH_REPLY");
            }
            this.serverHostKey = sSH2TransportPDU.readString();
            this.serverF = sSH2TransportPDU.readBigInt();
            byte[] byArray = sSH2TransportPDU.readString();
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(this.serverF, group1P, group1G);
            this.computeSharedSecret_K(dHPublicKeySpec);
            this.computeExchangeHash_H();
            this.transport.authenticateHost(this.serverHostKey, byArray, this.exchangeHash_H);
            this.transport.sendNewKeys();
        } else if (sSH2TransportPDU.getType() == 30) {
            // empty if block
        }
    }

    public MessageDigest getExchangeHashAlgorithm() {
        this.sha1.reset();
        return this.sha1;
    }

    public byte[] getSharedSecret_K() {
        SSH2DataBuffer sSH2DataBuffer = new SSH2DataBuffer(1024);
        sSH2DataBuffer.writeString(this.sharedSecret_K);
        return sSH2DataBuffer.readRestRaw();
    }

    public byte[] getExchangeHash_H() {
        return this.exchangeHash_H;
    }

    public String getHostKeyAlgorithms() {
        return "ssh-dss,ssh-rsa";
    }

    protected void computeExchangeHash_H() {
        SSH2DataBuffer sSH2DataBuffer = new SSH2DataBuffer(65536);
        if (this.transport.isServer()) {
            this.serverF = this.dhPublicKey.getY();
        } else {
            this.clientE = this.dhPublicKey.getY();
        }
        sSH2DataBuffer.writeString(this.transport.getClientVersion());
        sSH2DataBuffer.writeString(this.transport.getServerVersion());
        sSH2DataBuffer.writeString(this.transport.getClientKEXINITPDU().getData(), this.transport.getClientKEXINITPDU().getPayloadOffset(), this.transport.getClientKEXINITPDU().getPayloadLength());
        sSH2DataBuffer.writeString(this.transport.getServerKEXINITPDU().getData(), this.transport.getServerKEXINITPDU().getPayloadOffset(), this.transport.getServerKEXINITPDU().getPayloadLength());
        sSH2DataBuffer.writeString(this.serverHostKey);
        sSH2DataBuffer.writeBigInt(this.clientE);
        sSH2DataBuffer.writeBigInt(this.serverF);
        sSH2DataBuffer.writeString(this.sharedSecret_K);
        this.sha1.reset();
        this.sha1.update(sSH2DataBuffer.getData(), 0, sSH2DataBuffer.getWPos());
        this.exchangeHash_H = this.sha1.digest();
        this.transport.getLog().debug2("SSH2KEXDHGroup1SHA1", "computeExchangeHash_H", "E: ", this.clientE.toByteArray());
        this.transport.getLog().debug2("SSH2KEXDHGroup1SHA1", "computeExchangeHash_H", "F: ", this.serverF.toByteArray());
        this.transport.getLog().debug2("SSH2KEXDHGroup1SHA1", "computeExchangeHash_H", "K: ", this.sharedSecret_K);
        this.transport.getLog().debug2("SSH2KEXDHGroup1SHA1", "computeExchangeHash_H", "Hash over: ", sSH2DataBuffer.getData(), 0, sSH2DataBuffer.getWPos());
        this.transport.getLog().debug2("SSH2KEXDHGroup1SHA1", "computeExchangeHash_H", "H: ", this.exchangeHash_H);
    }

    protected void computeSharedSecret_K(DHPublicKeySpec dHPublicKeySpec) throws SSH2Exception {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DH");
            KeyAgreement keyAgreement = KeyAgreement.getInstance("DH");
            DHPublicKey dHPublicKey = (DHPublicKey)keyFactory.generatePublic(dHPublicKeySpec);
            keyAgreement.init(this.dhPrivateKey);
            keyAgreement.doPhase(dHPublicKey, true);
            this.sharedSecret_K = keyAgreement.generateSecret();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SSH2FatalException("Error computing shared secret: " + exception);
        }
    }

    protected void sendDHINIT(int n) throws SSH2Exception {
        SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(n);
        sSH2TransportPDU.writeBigInt(this.dhPublicKey.getY());
        this.transport.transmitInternal(sSH2TransportPDU);
    }

    protected MessageDigest createHash() throws SSH2Exception {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (Exception exception) {
            throw new SSH2KEXFailedException("SHA1 not implemented", exception);
        }
    }

    protected void generateDHKeyPair(DHParameterSpec dHParameterSpec) throws SSH2Exception {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
            keyPairGenerator.initialize(dHParameterSpec, this.transport.getSecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.dhPrivateKey = (DHPrivateKey)keyPair.getPrivate();
            this.dhPublicKey = (DHPublicKey)keyPair.getPublic();
        }
        catch (Exception exception) {
            throw new SSH2FatalException("Error generating DiffieHellman keys: " + exception);
        }
    }
}

