/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2StreamChannel;
import com.mindbright.util.InputStreamPipe;
import com.mindbright.util.OutputStreamPipe;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SSH2InternalChannel
extends SSH2StreamChannel {
    protected InputStreamPipe rxPipe;
    protected OutputStreamPipe txPipe;

    public SSH2InternalChannel(int n, SSH2Connection sSH2Connection) {
        super(n, sSH2Connection, sSH2Connection, null, null);
        int n2 = sSH2Connection.getPreferences().getIntPreference("int-io-buf-sz");
        this.in = new InputStreamPipe(n2);
        this.out = new OutputStreamPipe();
        try {
            this.txPipe = new OutputStreamPipe();
            this.rxPipe = new InputStreamPipe(n2);
            this.rxPipe.connect((OutputStreamPipe)this.out);
            this.txPipe.connect((InputStreamPipe)this.in);
        }
        catch (IOException iOException) {
            sSH2Connection.getLog().error("SSH2InternalChannel", "<constructor>", "can't happen, bug somewhere!?!");
        }
    }

    public InputStream getInputStream() {
        return this.rxPipe;
    }

    public OutputStream getOutputStream() {
        return this.txPipe;
    }
}

