/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

public abstract class SSH2 {
    public static final int SSH_VER_MAJOR = 2;
    public static final int SSH_VER_MINOR = 0;
    public static final int PKG_VER_MAJOR = 3;
    public static final int PKG_VER_MINOR = 0;
    public static final String PKG_NAME = "MindTerm";
    public static final int MAX_PAYLOAD_LENGTH = 32768;
    public static final int MSG_DISCONNECT = 1;
    public static final int MSG_IGNORE = 2;
    public static final int MSG_UNIMPLEMENTED = 3;
    public static final int MSG_DEBUG = 4;
    public static final int MSG_SERVICE_REQUEST = 5;
    public static final int MSG_SERVICE_ACCEPT = 6;
    public static final int MSG_KEXINIT = 20;
    public static final int MSG_NEWKEYS = 21;
    public static final int FIRST_KEX_PACKET = 30;
    public static final int MSG_KEXDH_INIT = 30;
    public static final int MSG_KEXDH_REPLY = 31;
    public static final int MSG_KEXDH_GEX_REQUEST = 30;
    public static final int MSG_KEXDH_GEX_GROUP = 31;
    public static final int MSG_KEXDH_GEX_INIT = 32;
    public static final int MSG_KEXDH_GEX_REPLY = 33;
    public static final int LAST_KEX_PACKET = 49;
    public static final int FIRST_SERVICE_PACKET = 50;
    public static final int MSG_USERAUTH_REQUEST = 50;
    public static final int MSG_USERAUTH_FAILURE = 51;
    public static final int MSG_USERAUTH_SUCCESS = 52;
    public static final int MSG_USERAUTH_BANNER = 53;
    public static final int FIRST_USERAUTH_METHOD_PACKET = 60;
    public static final int LAST_USERAUTH_METHOD_PACKET = 79;
    public static final int MSG_USERAUTH_PASSWD_CHANGEREQ = 60;
    public static final int MSG_USERAUTH_CHALLENGE = 60;
    public static final int MSG_USERAUTH_SECURID_CHALLENGE = 60;
    public static final int MSG_USERAUTH_SECURID_NEW_PIN_REQD = 61;
    public static final int SSH_SECURID_CANNOT_CHOOSE_PIN = 0;
    public static final int SSH_SECURID_MUST_CHOOSE_PIN = 1;
    public static final int SSH_SECURID_USER_SELECTABLE_PIN = 2;
    public static final int MSG_USERAUTH_PK_OK = 60;
    public static final int MSG_USERAUTH_INFO_REQUEST = 60;
    public static final int MSG_USERAUTH_INFO_RESPONSE = 61;
    public static final int MSG_GLOBAL_REQUEST = 80;
    public static final int MSG_REQUEST_SUCCESS = 81;
    public static final int MSG_REQUEST_FAILURE = 82;
    public static final int MSG_CHANNEL_OPEN = 90;
    public static final int MSG_CHANNEL_OPEN_CONFIRMATION = 91;
    public static final int MSG_CHANNEL_OPEN_FAILURE = 92;
    public static final int MSG_CHANNEL_WINDOW_ADJUST = 93;
    public static final int MSG_CHANNEL_DATA = 94;
    public static final int MSG_CHANNEL_EXTENDED_DATA = 95;
    public static final int MSG_CHANNEL_EOF = 96;
    public static final int MSG_CHANNEL_CLOSE = 97;
    public static final int MSG_CHANNEL_REQUEST = 98;
    public static final int MSG_CHANNEL_SUCCESS = 99;
    public static final int MSG_CHANNEL_FAILURE = 100;
    public static final int MSG_RESERVED = 255;
    public static final int DEBUG_DEBUG = 0;
    public static final int DEBUG_DISPLAY = 1;
    public static final int DISCONNECT_HOST_NOT_ALLOWED_TO_CONNECT = 1;
    public static final int DISCONNECT_PROTOCOL_ERROR = 2;
    public static final int DISCONNECT_KEY_EXCHANGE_FAILED = 3;
    public static final int DISCONNECT_RESERVED = 4;
    public static final int DISCONNECT_MAC_ERROR = 5;
    public static final int DISCONNECT_COMPRESSION_ERROR = 6;
    public static final int DISCONNECT_SERVICE_NOT_AVAILABLE = 7;
    public static final int DISCONNECT_PROTOCOL_VERSION_NOT_SUPPORTED = 8;
    public static final int DISCONNECT_HOST_KEY_NOT_VERIFIABLE = 9;
    public static final int DISCONNECT_CONNECTION_LOST = 10;
    public static final int DISCONNECT_BY_APPLICATION = 11;
    public static final int DISCONNECT_TOO_MANY_CONNECTIONS = 12;
    public static final int DISCONNECT_AUTH_CANCELLED_BY_USER = 13;
    public static final int DISCONNECT_NO_MORE_AUTH_METHODS_AVAILABLE = 14;
    public static final int DISCONNECT_ILLEGAL_USER_NAME = 15;
    public static final int EXTENDED_DATA_STDERR = 1;
    public static final int OPEN_OK = 0;
    public static final int OPEN_ADMINISTRATIVELY_PROHIBITED = 1;
    public static final int OPEN_CONNECT_FAILED = 2;
    public static final int OPEN_UNKNOWN_CHANNEL_TYPE = 3;
    public static final int OPEN_RESOURCE_SHORTAGE = 4;

    public static final String getPackageVersion(String string, int n, int n2, String string2) {
        return string + "_" + n + "." + n2 + " " + string2;
    }

    public static final String getVersionId() {
        return SSH2.getVersionId(SSH2.getPackageVersion(PKG_NAME, 3, 0, "(AppGate Network Security AB SSH2)"));
    }

    public static final String getVersionId(String string) {
        String string2 = string == null ? SSH2.getVersionId() : "SSH-2.0-" + string;
        return string2;
    }

    public static final String msgTypeString(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "MSG_DISCONNECT";
                break;
            }
            case 2: {
                string = "MSG_IGNORE";
                break;
            }
            case 3: {
                string = "MSG_UNIMPLEMENTED";
                break;
            }
            case 4: {
                string = "MSG_DEBUG";
                break;
            }
            case 5: {
                string = "MSG_SERVICE_REQUEST";
                break;
            }
            case 6: {
                string = "MSG_SERVICE_ACCEPT";
                break;
            }
            case 20: {
                string = "MSG_KEXINIT";
                break;
            }
            case 21: {
                string = "MSG_NEWKEYS";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                string = "KEX_METHOD_PACKET_" + n;
                break;
            }
            case 50: {
                string = "MSG_USERAUTH_REQUEST";
                break;
            }
            case 51: {
                string = "MSG_USERAUTH_FAILURE";
                break;
            }
            case 52: {
                string = "MSG_USERAUTH_SUCCESS";
                break;
            }
            case 53: {
                string = "MSG_USERAUTH_BANNER";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                string = "USERAUTH_METHOD_PACKET_" + n;
                break;
            }
            case 80: {
                string = "MSG_GLOBAL_REQUEST";
                break;
            }
            case 81: {
                string = "MSG_REQUEST_SUCCESS";
                break;
            }
            case 82: {
                string = "MSG_REQUEST_FAILURE";
                break;
            }
            case 90: {
                string = "MSG_CHANNEL_OPEN";
                break;
            }
            case 91: {
                string = "MSG_CHANNEL_OPEN_CONFIRMATION";
                break;
            }
            case 92: {
                string = "MSG_CHANNEL_OPEN_FAILURE";
                break;
            }
            case 93: {
                string = "MSG_CHANNEL_WINDOW_ADJUST";
                break;
            }
            case 94: {
                string = "MSG_CHANNEL_DATA";
                break;
            }
            case 95: {
                string = "MSG_CHANNEL_EXTENDED_DATA";
                break;
            }
            case 96: {
                string = "MSG_CHANNEL_EOF";
                break;
            }
            case 97: {
                string = "MSG_CHANNEL_CLOSE";
                break;
            }
            case 98: {
                string = "MSG_CHANNEL_REQUEST";
                break;
            }
            case 99: {
                string = "MSG_CHANNEL_SUCCESS";
                break;
            }
            case 100: {
                string = "MSG_CHANNEL_FAILURE";
                break;
            }
            default: {
                string = "<unknown: " + n + ">";
            }
        }
        return string;
    }
}

