/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.BorderDialog;
import com.mindbright.ssh.SSHClient;
import com.mindbright.ssh.SSHInteractiveClient;
import com.mindbright.ssh.SSHMiscDialogs;
import com.mindbright.ssh.SSHPropertyHandler;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public final class SSHTunnelDialogAWT {
    private static final String LBL_CURRENT_TUNNELS = "Current tunnels";
    private static final String LBL_LOCAL = "Local";
    private static final String LBL_REMOTE = "Remote";
    private static final String LBL_LOCALHOST = "localhost";
    private static final String LBL_ALL_HOSTS = "all (0.0.0.0)";
    private static final String LBL_IP = "ip";
    private static final String LBL_TYPE = "Type";
    private static final String LBL_PLUGIN = "Plugin";
    private static final String LBL_SRC_PORT = "Bind port";
    private static final String LBL_BIND_ADDR = "Bind address";
    private static final String LBL_DEST_ADDR = "Dest. address";
    private static final String LBL_DEST_PORT = "Dest. port";
    private static final String LBL_BTN_ADD = "Add...";
    private static final String LBL_BTN_DEL = "Delete";
    private static final String LBL_BTN_DISMISS = "Dimiss";
    private static final String LBL_BTN_OK = "OK";
    private static final String LBL_BTN_CANCEL = "Cancel";
    private static final String PLUGIN_NONE = "none";
    private static final String PLUGIN_FTP = "ftp";
    private static final String[] PLUGIN_NAMES = new String[]{"none", "ftp"};
    private static final int[] PLUGIN_PORTS = new int[]{0, 21};
    private static SSHPropertyHandler propsHandler;
    private static Frame parent;
    private static SSHInteractiveClient client;
    private static List tunnelList;
    private static Button delButton;

    private static void showAddDialog() {
        final BorderDialog borderDialog = new BorderDialog(parent, "Add tunnel", true);
        Panel panel = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        final Checkbox checkbox = new Checkbox(LBL_LOCAL, checkboxGroup, true);
        Checkbox checkbox2 = new Checkbox(LBL_REMOTE, checkboxGroup, false);
        Panel panel2 = new Panel(new FlowLayout(0, 0, 0));
        panel2.add(checkbox);
        panel2.add(checkbox2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        panel.add((Component)new Label(LBL_TYPE), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        panel.add((Component)panel2, gridBagConstraints);
        checkboxGroup = new CheckboxGroup();
        final Checkbox checkbox3 = new Checkbox(LBL_LOCALHOST, checkboxGroup, true);
        final Checkbox checkbox4 = new Checkbox(LBL_ALL_HOSTS, checkboxGroup, false);
        Checkbox checkbox5 = new Checkbox(LBL_IP, checkboxGroup, false);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        panel.add((Component)new Label(LBL_BIND_ADDR), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)checkbox3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        panel.add((Component)checkbox4, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        panel2 = new Panel(new FlowLayout(0, 0, 0));
        panel2.add(checkbox5);
        final TextField textField = new TextField("", 16);
        textField.setEnabled(false);
        panel2.add(textField);
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)panel2, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        panel.add((Component)new Label(LBL_SRC_PORT), gridBagConstraints);
        final TextField textField2 = new TextField("", 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)textField2, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        panel.add((Component)new Label(LBL_DEST_ADDR), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        final TextField textField3 = new TextField("", 16);
        panel.add((Component)textField3, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        panel.add((Component)new Label(LBL_DEST_PORT), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        final TextField textField4 = new TextField("", 5);
        panel.add((Component)textField4, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        final Label label = new Label(LBL_PLUGIN);
        panel.add((Component)label, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        final Choice choice = AWTConvenience.newChoice(PLUGIN_NAMES);
        panel.add((Component)choice, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panel.add((Component)new Panel(), gridBagConstraints);
        Button button = new Button(LBL_BTN_OK);
        button.setActionCommand("ok");
        Button button2 = new Button(LBL_BTN_CANCEL);
        button2.addActionListener(new AWTConvenience.CloseAction(borderDialog));
        borderDialog.add((Component)panel, "Center");
        borderDialog.add((Component)AWTConvenience.newButtonPanel(new Component[]{button, button2}), "South");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                int n = -1;
                int n2 = -1;
                try {
                    n = Integer.valueOf(textField2.getText());
                    n2 = Integer.valueOf(textField4.getText());
                    if (n < 1 || n > 65535) {
                        n = -1;
                        throw new NumberFormatException();
                    }
                    if (n2 < 1 || n2 > 65535) {
                        n2 = -1;
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (n == -1) {
                        textField2.setText("");
                        textField2.requestFocus();
                    } else {
                        textField4.setText("");
                        textField4.requestFocus();
                    }
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                String string2 = choice.getSelectedItem();
                if (string2.equals(SSHTunnelDialogAWT.PLUGIN_NONE)) {
                    string2 = "general";
                }
                if ((string = textField3.getText().trim()).equals("")) {
                    textField4.requestFocus();
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                try {
                    String string3 = checkbox.getState() ? "local" + client.localForwards.size() : "remote" + client.remoteForwards.size();
                    String string4 = "";
                    if (checkbox3.getState()) {
                        string4 = "127.0.0.1";
                    } else if (checkbox4.getState()) {
                        string4 = "0.0.0.0";
                    } else {
                        string4 = textField.getText().trim();
                        if (string4.equals("")) {
                            textField.requestFocus();
                            Toolkit.getDefaultToolkit().beep();
                            return;
                        }
                    }
                    propsHandler.setProperty(string3, "/" + string2 + "/" + string4 + ":" + n + ":" + string + ":" + n2);
                }
                catch (Throwable throwable) {
                    SSHMiscDialogs.alert("Tunnel Notice", "Could not open tunnel: " + throwable.getMessage(), parent);
                    return;
                }
                borderDialog.dispose();
            }
        };
        button.addActionListener(actionListener);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (checkbox.getState()) {
                    label.setEnabled(true);
                    choice.setEnabled(true);
                } else {
                    label.setEnabled(false);
                    choice.setEnabled(false);
                    choice.select(0);
                }
                if (checkbox3.getState()) {
                    textField.setEnabled(false);
                    textField.setText("");
                } else if (checkbox4.getState()) {
                    textField.setEnabled(false);
                    textField.setText("");
                } else {
                    textField.setEnabled(true);
                }
            }
        };
        checkbox.addItemListener(itemListener);
        checkbox2.addItemListener(itemListener);
        checkbox3.addItemListener(itemListener);
        checkbox4.addItemListener(itemListener);
        checkbox5.addItemListener(itemListener);
        textField2.requestFocus();
        borderDialog.setResizable(false);
        borderDialog.pack();
        AWTConvenience.placeDialog(borderDialog);
        borderDialog.addWindowListener(new AWTConvenience.CloseAdapter(button2));
        ((Component)borderDialog).setVisible(true);
    }

    public static void show(String string, SSHInteractiveClient sSHInteractiveClient, SSHPropertyHandler sSHPropertyHandler, Frame frame) {
        propsHandler = sSHPropertyHandler;
        parent = frame;
        client = sSHInteractiveClient;
        BorderDialog borderDialog = new BorderDialog(parent, string, true);
        Action action = new Action();
        tunnelList = new List(8);
        borderDialog.add((Component)tunnelList, "Center");
        tunnelList.addItemListener(action);
        Button button = new Button(LBL_BTN_ADD);
        button.setActionCommand("add");
        button.addActionListener(action);
        delButton = new Button(LBL_BTN_DEL);
        delButton.setActionCommand("del");
        delButton.addActionListener(action);
        delButton.setEnabled(false);
        Button button2 = new Button(LBL_BTN_DISMISS);
        button2.addActionListener(new AWTConvenience.CloseAction(borderDialog));
        borderDialog.add((Component)AWTConvenience.newButtonPanel(new Component[]{new Label(""), new Label(""), button, delButton, button2}), "South");
        SSHTunnelDialogAWT.updateTunnelList();
        borderDialog.setResizable(true);
        borderDialog.pack();
        AWTConvenience.placeDialog(borderDialog);
        ((Component)borderDialog).setVisible(true);
    }

    private static void updateTunnelList() {
        Object object;
        int n;
        int n2 = SSHTunnelDialogAWT.client.localForwards.size();
        int n3 = SSHTunnelDialogAWT.client.remoteForwards.size();
        String[] stringArray = new String[n2 + n3];
        for (n = 0; n < n2; ++n) {
            object = (SSHClient.LocalForward)SSHTunnelDialogAWT.client.localForwards.elementAt(n);
            String string = ((SSHClient.LocalForward)object).plugin.equals("general") ? "" : " (plugin: " + ((SSHClient.LocalForward)object).plugin + ")";
            stringArray[n] = "L: " + ((SSHClient.LocalForward)object).localHost + ":" + ((SSHClient.LocalForward)object).localPort + " --> " + ((SSHClient.LocalForward)object).remoteHost + ":" + ((SSHClient.LocalForward)object).remotePort + string;
        }
        for (n = 0; n < n3; ++n) {
            object = (SSHClient.RemoteForward)SSHTunnelDialogAWT.client.remoteForwards.elementAt(n);
            stringArray[n + n2] = "R: " + ((SSHClient.RemoteForward)object).localHost + ":" + ((SSHClient.RemoteForward)object).localPort + " <-- " + ((SSHClient.RemoteForward)object).remoteHost + ":" + ((SSHClient.RemoteForward)object).remotePort;
        }
        tunnelList.removeAll();
        for (n = 0; n < stringArray.length; ++n) {
            tunnelList.addItem(stringArray[n]);
        }
    }

    private static class Action
    implements ActionListener,
    ItemListener {
        private Action() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("add".equals(string)) {
                SSHTunnelDialogAWT.showAddDialog();
            } else if ("del".equals(string)) {
                int n = tunnelList.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                int n2 = client.localForwards.size();
                if (n < n2) {
                    propsHandler.removeLocalTunnelAt(n, true);
                } else {
                    propsHandler.removeRemoteTunnelAt(n - n2);
                }
            }
            SSHTunnelDialogAWT.updateTunnelList();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n = tunnelList.getSelectedIndex();
            delButton.setEnabled(n >= 0);
        }
    }
}

