/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.security.cipher.Blowfish;
import com.mindbright.ssh.SSHCipher;

public final class SSHBlowfish
extends SSHCipher {
    Blowfish blowfish = new Blowfish();
    byte[] IV = new byte[8];
    byte[] enc = new byte[8];
    byte[] dec = new byte[8];

    public void setKey(String string) {
        if (string.length() != 0) {
            byte[] byArray = string.getBytes();
            this.setKey(byArray);
        }
    }

    public void setKey(byte[] byArray) {
        try {
            this.blowfish.initializeKey(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new Error("Internal error, invalid key in SSHBlowfish");
        }
    }

    public synchronized void encrypt(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n;
        int n6 = n2;
        while (n5 < n4) {
            int n7;
            int n8;
            for (n8 = 0; n8 < 4; ++n8) {
                n7 = 3 - n8;
                int n9 = n8;
                this.IV[n9] = (byte)(this.IV[n9] ^ byArray[n5 + n7]);
                int n10 = n8 + 4;
                this.IV[n10] = (byte)(this.IV[n10] ^ byArray[n5 + 4 + n7]);
            }
            this.blowfish.blockEncrypt(this.IV, 0, this.IV, 0);
            for (n8 = 0; n8 < 4; ++n8) {
                n7 = 3 - n8;
                byArray2[n6 + n8] = this.IV[n7];
                byArray2[n6 + n8 + 4] = this.IV[4 + n7];
            }
            n5 += 8;
            n6 += 8;
        }
    }

    public synchronized void decrypt(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n;
        int n6 = n2;
        while (n5 < n4) {
            int n7;
            int n8;
            for (n8 = 0; n8 < 4; ++n8) {
                n7 = 3 - n8;
                this.enc[n8] = byArray[n5 + n7];
                this.enc[n8 + 4] = byArray[n5 + 4 + n7];
            }
            this.blowfish.blockDecrypt(this.enc, 0, this.dec, 0);
            for (n8 = 0; n8 < 4; ++n8) {
                n7 = 3 - n8;
                byArray2[n6 + n8] = (byte)((this.IV[n7] ^ this.dec[n7]) & 0xFF);
                this.IV[n7] = this.enc[n7];
                byArray2[n6 + n8 + 4] = (byte)((this.IV[4 + n7] ^ this.dec[4 + n7]) & 0xFF);
                this.IV[4 + n7] = this.enc[4 + n7];
            }
            n5 += 8;
            n6 += 8;
        }
    }
}

