/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.x509;

import com.mindbright.asn1.ASN1DER;
import com.mindbright.asn1.ASN1OIDRegistry;
import com.mindbright.jca.security.cert.CRL;
import com.mindbright.jca.security.cert.Certificate;
import com.mindbright.security.x509.CertificateList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class X509CRL
extends CRL {
    private CertificateList certList;

    public X509CRL(byte[] byArray) {
        this(new ByteArrayInputStream(byArray));
    }

    public X509CRL(InputStream inputStream) {
        super("X.509");
        this.init(inputStream);
    }

    private void init(InputStream inputStream) {
        this.certList = new CertificateList();
        ASN1OIDRegistry.addModule("com.mindbright.security.x509");
        ASN1OIDRegistry.addModule("com.mindbright.security.pkcs1");
        try {
            new ASN1DER().decode(inputStream, this.certList);
        }
        catch (IOException iOException) {
            throw new Error("Internal error decoding DER encoded X.509 CRL: " + iOException.getMessage());
        }
    }

    public boolean isRevoked(Certificate certificate) {
        return true;
    }

    public String toString() {
        return "X509CRL: certList=" + this.certList;
    }
}

