/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.publickey;

import com.mindbright.jca.security.KeyPair;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.SignatureException;
import com.mindbright.security.publickey.RSAPrivateCrtKey;
import com.mindbright.security.publickey.RSAPublicKey;
import java.math.BigInteger;

public final class RSAAlgorithm {
    private static final BigInteger one = BigInteger.valueOf(1L);

    public static BigInteger doPublic(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger.modPow(bigInteger3, bigInteger2);
    }

    public static BigInteger doPrivate(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return RSAAlgorithm.doPublic(bigInteger, bigInteger2, bigInteger3);
    }

    public static BigInteger doPrivateCrt(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
        return RSAAlgorithm.doPrivateCrt(bigInteger, bigInteger3, bigInteger4, RSAAlgorithm.getPrimeExponent(bigInteger2, bigInteger3), RSAAlgorithm.getPrimeExponent(bigInteger2, bigInteger4), bigInteger5);
    }

    public static BigInteger doPrivateCrt(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6) {
        BigInteger bigInteger7;
        if (!bigInteger6.equals(bigInteger3.modInverse(bigInteger2))) {
            bigInteger7 = bigInteger2;
            bigInteger3 = bigInteger2 = bigInteger3;
            bigInteger7 = bigInteger4;
            bigInteger4 = bigInteger5;
            bigInteger5 = bigInteger7;
        }
        bigInteger7 = bigInteger.modPow(bigInteger4, bigInteger2);
        BigInteger bigInteger8 = bigInteger.modPow(bigInteger5, bigInteger3);
        BigInteger bigInteger9 = bigInteger6.multiply(bigInteger7.subtract(bigInteger8)).mod(bigInteger2);
        return bigInteger8.add(bigInteger9.multiply(bigInteger3));
    }

    public static BigInteger getPrimeExponent(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger2.subtract(one);
        return bigInteger.mod(bigInteger3);
    }

    public static BigInteger addPKCS1Pad(BigInteger bigInteger, int n, int n2, SecureRandom secureRandom) throws SignatureException {
        int n3 = (bigInteger.bitLength() + 7) / 8;
        if (n3 > n2 - 11) {
            throw new SignatureException("PKCS1Pad: Input too long to pad");
        }
        byte[] byArray = new byte[n2 - n3 - 3 + 1];
        byArray[0] = 0;
        for (int i = 1; i < n2 - n3 - 3 + 1; ++i) {
            if (n == 1) {
                byArray[i] = -1;
                continue;
            }
            byte[] byArray2 = new byte[1];
            do {
                secureRandom.nextBytes(byArray2);
            } while (byArray2[0] == 0);
            byArray[i] = byArray2[0];
        }
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        bigInteger2 = bigInteger2.shiftLeft((n3 + 1) * 8);
        BigInteger bigInteger3 = BigInteger.valueOf(n);
        bigInteger3 = bigInteger3.shiftLeft((n2 - 2) * 8);
        bigInteger3 = bigInteger3.or(bigInteger2);
        bigInteger3 = bigInteger3.or(bigInteger);
        return bigInteger3;
    }

    public static BigInteger stripPKCS1Pad(BigInteger bigInteger, int n) throws SignatureException {
        int n2;
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] != n) {
            throw new SignatureException("Invalid PKCS1 padding, type != " + n);
        }
        for (n2 = 1; n2 < byArray.length && byArray[n2] != 0; ++n2) {
            if (n != 1 || byArray[n2] == -1) continue;
            throw new SignatureException("Invalid PKCS1 padding, corrupt data");
        }
        if (n2 == byArray.length) {
            throw new SignatureException("Invalid PKCS1 padding, corrupt data");
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return new BigInteger(1, byArray2);
    }

    public static KeyPair generateKeyPair(int n, SecureRandom secureRandom) {
        return RSAAlgorithm.generateKeyPair(n, BigInteger.valueOf(65537L), secureRandom);
    }

    public static KeyPair generateKeyPair(int n, BigInteger bigInteger, SecureRandom secureRandom) {
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        BigInteger bigInteger5 = null;
        BigInteger bigInteger6 = null;
        BigInteger bigInteger7 = null;
        BigInteger bigInteger8 = null;
        boolean bl = false;
        int n2 = (n + 1) / 2;
        int n3 = n - n2;
        while (!bl) {
            bigInteger2 = new BigInteger(n2, 80, secureRandom);
            bigInteger3 = new BigInteger(n3, 80, secureRandom);
            if (bigInteger2.compareTo(bigInteger3) == 0) continue;
            if (bigInteger2.compareTo(bigInteger3) < 0) {
                bigInteger4 = bigInteger3;
                bigInteger3 = bigInteger2;
                bigInteger2 = bigInteger4;
            }
            if ((bigInteger4 = bigInteger2.gcd(bigInteger3)).compareTo(one) != 0 || (bigInteger8 = bigInteger2.multiply(bigInteger3)).bitLength() != n) continue;
            bigInteger5 = bigInteger2.subtract(one).multiply(bigInteger3.subtract(one));
            bigInteger6 = bigInteger.modInverse(bigInteger5);
            bigInteger7 = bigInteger3.modInverse(bigInteger2);
            bl = true;
        }
        RSAPrivateCrtKey rSAPrivateCrtKey = new RSAPrivateCrtKey(bigInteger8, bigInteger, bigInteger6, bigInteger2, bigInteger3, bigInteger7);
        RSAPublicKey rSAPublicKey = new RSAPublicKey(bigInteger8, bigInteger);
        return new KeyPair(rSAPublicKey, rSAPrivateCrtKey);
    }
}

