/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.publickey;

import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.spec.DSAParameterSpec;
import com.mindbright.util.Math;
import java.math.BigInteger;

public final class DSAAlgorithm {
    private static final BigInteger one = BigInteger.valueOf(1L);

    public static byte[] sign(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, byte[] byArray) {
        BigInteger bigInteger5 = new BigInteger(1, byArray);
        bigInteger5 = bigInteger5.mod(bigInteger3);
        BigInteger bigInteger6 = bigInteger4.modPow(bigInteger, bigInteger2).mod(bigInteger3);
        BigInteger bigInteger7 = bigInteger.modInverse(bigInteger3).multiply(bigInteger5.add(bigInteger.multiply(bigInteger6))).mod(bigInteger3);
        int n = byArray.length;
        byte[] byArray2 = new byte[n * 2];
        byte[] byArray3 = DSAAlgorithm.unsignedBigIntToBytes(bigInteger6, n);
        System.arraycopy(byArray3, 0, byArray2, 0, n);
        byArray3 = DSAAlgorithm.unsignedBigIntToBytes(bigInteger7, n);
        System.arraycopy(byArray3, 0, byArray2, n, n);
        return byArray2;
    }

    public static boolean verify(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, byte[] byArray, byte[] byArray2) {
        int n = byArray.length / 2;
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray, n, byArray4, 0, n);
        BigInteger bigInteger5 = new BigInteger(1, byArray2);
        BigInteger bigInteger6 = new BigInteger(1, byArray3);
        BigInteger bigInteger7 = new BigInteger(1, byArray4);
        bigInteger5 = bigInteger5.mod(bigInteger3);
        BigInteger bigInteger8 = bigInteger7.modInverse(bigInteger3);
        BigInteger bigInteger9 = bigInteger5.multiply(bigInteger8).mod(bigInteger3);
        BigInteger bigInteger10 = bigInteger6.multiply(bigInteger8).mod(bigInteger3);
        BigInteger bigInteger11 = bigInteger4.modPow(bigInteger9, bigInteger2).multiply(bigInteger.modPow(bigInteger10, bigInteger2)).mod(bigInteger2).mod(bigInteger3);
        return bigInteger11.compareTo(bigInteger6) == 0;
    }

    private static byte[] unsignedBigIntToBytes(BigInteger bigInteger, int n) {
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = null;
        if (byArray.length > n) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, byArray.length - n, byArray2, 0, n);
        } else if (byArray.length < n) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
        } else {
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static DSAParameterSpec generateParams(int n, int n2, SecureRandom secureRandom) {
        BigInteger[] bigIntegerArray = Math.findRandomStrongPrime(n, n2, secureRandom);
        BigInteger bigInteger = Math.findRandomGenerator(bigIntegerArray[1], bigIntegerArray[0], secureRandom);
        return new DSAParameterSpec(bigIntegerArray[0], bigIntegerArray[1], bigInteger);
    }

    public static BigInteger generatePrivateKey(BigInteger bigInteger, SecureRandom secureRandom) {
        BigInteger bigInteger2;
        while ((bigInteger2 = new BigInteger(bigInteger.bitLength(), secureRandom)).compareTo(one) < 0 || bigInteger2.compareTo(bigInteger) > 0) {
        }
        return bigInteger2;
    }

    public static BigInteger generatePublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger.modPow(bigInteger3, bigInteger2);
    }
}

