/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.publickey;

import com.mindbright.jca.security.InvalidAlgorithmParameterException;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.InvalidParameterException;
import com.mindbright.jca.security.MessageDigest;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.PrivateKey;
import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.SignatureException;
import com.mindbright.jca.security.SignatureSpi;
import com.mindbright.jca.security.spec.AlgorithmParameterSpec;

public abstract class BaseSignature
extends SignatureSpi {
    protected MessageDigest digest;
    protected PublicKey publicKey;
    protected PrivateKey privateKey;

    protected BaseSignature(String string) {
        try {
            this.digest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("Error in BaseSignature, no " + string + " found");
        }
    }

    protected final void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.publicKey = publicKey;
        this.initVerify();
    }

    protected final void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    protected final void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.privateKey = privateKey;
        this.appRandom = secureRandom;
        this.initSign();
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.digest.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.digest.update(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        return this.sign(this.digest.digest());
    }

    protected int engineSign(byte[] byArray, int n, int n2) throws SignatureException {
        byte[] byArray2 = this.sign(this.digest.digest());
        if (byArray2.length < n2) {
            n2 = byArray2.length;
        }
        System.arraycopy(byArray2, 0, byArray, n, n2);
        return n2;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.verify(byArray, this.digest.digest());
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("Param not supported: " + string);
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Param not supported: " + algorithmParameterSpec);
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Param not supported: " + string);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected final SecureRandom getRandom() {
        if (this.appRandom == null) {
            this.appRandom = new SecureRandom();
        }
        return this.appRandom;
    }

    protected abstract void initSign() throws InvalidKeyException;

    protected abstract void initVerify() throws InvalidKeyException;

    protected abstract byte[] sign(byte[] var1) throws SignatureException;

    protected abstract boolean verify(byte[] var1, byte[] var2) throws SignatureException;
}

