/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.digest;

import com.mindbright.jca.security.DigestException;
import com.mindbright.jca.security.MessageDigest;

public abstract class MD512BitBlock
extends MessageDigest
implements Cloneable {
    protected long count = 0L;
    protected int rest = 0;
    protected byte[] buffer = new byte[64];
    protected int digestLength;
    protected static final byte[] md4_padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    protected static final int rotateLeft(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    protected MD512BitBlock(String string, int n) {
        super(string);
        this.digestLength = n;
    }

    public final Object clone() {
        MD512BitBlock mD512BitBlock = this.cloneInternal();
        System.arraycopy(mD512BitBlock.buffer, 0, this.buffer, 0, this.rest);
        mD512BitBlock.count = this.count;
        mD512BitBlock.rest = this.rest;
        return mD512BitBlock;
    }

    protected final void engineUpdate(byte by) {
        this.engineUpdate(new byte[]{by}, 0, 1);
    }

    protected final void engineUpdate(byte[] byArray, int n, int n2) {
        int n3 = 64 - this.rest;
        this.count += (long)n2;
        if (this.rest > 0 && n2 >= n3) {
            System.arraycopy(byArray, n, this.buffer, this.rest, n3);
            this.transform(this.buffer, 0);
            n += n3;
            n2 -= n3;
            this.rest = 0;
        }
        while (n2 > 63) {
            this.transform(byArray, n);
            n += 64;
            n2 -= 64;
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.buffer, this.rest, n2);
            this.rest += n2;
        }
    }

    protected final byte[] engineDigest() {
        byte[] byArray = new byte[this.digestLength];
        try {
            this.engineDigest(byArray, 0, byArray.length);
        }
        catch (DigestException digestException) {
            // empty catch block
        }
        return byArray;
    }

    protected final int engineGetDigestLength() {
        return this.digestLength;
    }

    protected abstract void transform(byte[] var1, int var2);

    protected abstract MD512BitBlock cloneInternal();
}

