/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.cipher;

import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.security.cipher.BlockCipher;

public final class RC2
extends BlockCipher {
    private static final int BLOCK_SIZE = 8;
    int[] K = new int[64];
    private static final byte[] PITABLE = new byte[]{-39, 120, -7, -60, 25, -35, -75, -19, 40, -23, -3, 121, 74, -96, -40, -99, -58, 126, 55, -125, 43, 118, 83, -114, 98, 76, 100, -120, 68, -117, -5, -94, 23, -102, 89, -11, -121, -77, 79, 19, 97, 69, 109, -115, 9, -127, 125, 50, -67, -113, 64, -21, -122, -73, 123, 11, -16, -107, 33, 34, 92, 107, 78, -126, 84, -42, 101, -109, -50, 96, -78, 28, 115, 86, -64, 20, -89, -116, -15, -36, 18, 117, -54, 31, 59, -66, -28, -47, 66, 61, -44, 48, -93, 60, -74, 38, 111, -65, 14, -38, 70, 105, 7, 87, 39, -14, 29, -101, -68, -108, 67, 3, -8, 17, -57, -10, -112, -17, 62, -25, 6, -61, -43, 47, -56, 102, 30, -41, 8, -24, -22, -34, -128, 82, -18, -9, -124, -86, 114, -84, 53, 77, 106, 42, -106, 26, -46, 113, 90, 21, 73, 116, 75, -97, -48, 94, 4, 24, -92, -20, -62, -32, 65, 110, 15, 81, -53, -52, 36, -111, -81, 80, -95, -12, 112, 57, -103, 124, 58, -123, 35, -72, -76, 122, -4, 2, 54, 91, 37, 85, -105, 49, 45, 93, -6, -104, -29, -118, -110, -82, 5, -33, 41, 16, 103, 108, -70, -55, -45, 0, -26, -49, -31, -98, -88, 44, 99, 22, 1, 63, 88, -30, -119, -87, 13, 56, 52, 27, -85, 51, -1, -80, -69, 72, 12, 95, -71, -79, -51, 46, -59, -13, -37, 71, -27, -91, -100, 119, 10, -90, 32, 104, -2, 127, -63, -83};

    public int getBlockSize() {
        return 8;
    }

    private static final int getWordLSBO(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    protected static final void putWordLSBO(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)(n >>> 8 & 0xFF);
    }

    private static int rotateLeft(int n, int n2) {
        return (n << n2 | n >>> 16 - n2) & 0xFFFF;
    }

    private static int rotateRight(int n, int n2) {
        return (n << 16 - n2 | n >>> n2) & 0xFFFF;
    }

    public synchronized void initializeKey(byte[] byArray) throws InvalidKeyException {
        int n;
        byte[] byArray2 = new byte[128];
        int n2 = byArray.length;
        if (n2 < 1 || n2 > 128) {
            throw new InvalidKeyException("Invalid key size for RC2");
        }
        for (n = 0; n < n2; ++n) {
            byArray2[n] = byArray[n];
        }
        for (n = n2; n < 128; ++n) {
            byArray2[n] = PITABLE[(byArray2[n - 1] & 0xFF) + (byArray2[n - n2] & 0xFF) & 0xFF];
        }
        byArray2[128 - n2] = PITABLE[byArray2[128 - n2] & 0xFF];
        for (n = 127 - n2; n >= 0; --n) {
            byArray2[n] = PITABLE[(byArray2[n + 1] & 0xFF ^ byArray2[n + n2] & 0xFF) & 0xFF];
        }
        for (n = 0; n < 64; ++n) {
            this.K[n] = RC2.getWordLSBO(byArray2, 2 * n);
        }
    }

    public void blockEncrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        int n4;
        int n5 = RC2.getWordLSBO(byArray, n + 0);
        int n6 = RC2.getWordLSBO(byArray, n + 2);
        int n7 = RC2.getWordLSBO(byArray, n + 4);
        int n8 = RC2.getWordLSBO(byArray, n + 6);
        for (n4 = 0; n4 < 5; ++n4) {
            n3 = n4 * 4;
            n5 = RC2.rotateLeft(n5 + (n6 & ~n8) + (n7 & n8) + this.K[n3 + 0] & 0xFFFF, 1);
            n6 = RC2.rotateLeft(n6 + (n7 & ~n5) + (n8 & n5) + this.K[n3 + 1] & 0xFFFF, 2);
            n7 = RC2.rotateLeft(n7 + (n8 & ~n6) + (n5 & n6) + this.K[n3 + 2] & 0xFFFF, 3);
            n8 = RC2.rotateLeft(n8 + (n5 & ~n7) + (n6 & n7) + this.K[n3 + 3] & 0xFFFF, 5);
        }
        n5 = n5 + this.K[n8 & 0x3F] & 0xFFFF;
        n6 = n6 + this.K[n5 & 0x3F] & 0xFFFF;
        n7 = n7 + this.K[n6 & 0x3F] & 0xFFFF;
        n8 = n8 + this.K[n7 & 0x3F] & 0xFFFF;
        for (n4 = 5; n4 < 11; ++n4) {
            n3 = n4 * 4;
            n5 = RC2.rotateLeft(n5 + (n6 & ~n8) + (n7 & n8) + this.K[n3 + 0] & 0xFFFF, 1);
            n6 = RC2.rotateLeft(n6 + (n7 & ~n5) + (n8 & n5) + this.K[n3 + 1] & 0xFFFF, 2);
            n7 = RC2.rotateLeft(n7 + (n8 & ~n6) + (n5 & n6) + this.K[n3 + 2] & 0xFFFF, 3);
            n8 = RC2.rotateLeft(n8 + (n5 & ~n7) + (n6 & n7) + this.K[n3 + 3] & 0xFFFF, 5);
        }
        n5 = n5 + this.K[n8 & 0x3F] & 0xFFFF;
        n6 = n6 + this.K[n5 & 0x3F] & 0xFFFF;
        n7 = n7 + this.K[n6 & 0x3F] & 0xFFFF;
        n8 = n8 + this.K[n7 & 0x3F] & 0xFFFF;
        for (n4 = 11; n4 < 16; ++n4) {
            n3 = n4 * 4;
            n5 = RC2.rotateLeft(n5 + (n6 & ~n8) + (n7 & n8) + this.K[n3 + 0] & 0xFFFF, 1);
            n6 = RC2.rotateLeft(n6 + (n7 & ~n5) + (n8 & n5) + this.K[n3 + 1] & 0xFFFF, 2);
            n7 = RC2.rotateLeft(n7 + (n8 & ~n6) + (n5 & n6) + this.K[n3 + 2] & 0xFFFF, 3);
            n8 = RC2.rotateLeft(n8 + (n5 & ~n7) + (n6 & n7) + this.K[n3 + 3] & 0xFFFF, 5);
        }
        RC2.putWordLSBO(n5, byArray2, n2 + 0);
        RC2.putWordLSBO(n6, byArray2, n2 + 2);
        RC2.putWordLSBO(n7, byArray2, n2 + 4);
        RC2.putWordLSBO(n8, byArray2, n2 + 6);
    }

    public void blockDecrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        int n4;
        int n5 = RC2.getWordLSBO(byArray, n + 0);
        int n6 = RC2.getWordLSBO(byArray, n + 2);
        int n7 = RC2.getWordLSBO(byArray, n + 4);
        int n8 = RC2.getWordLSBO(byArray, n + 6);
        for (n4 = 15; n4 > 10; --n4) {
            n3 = n4 * 4;
            n8 = RC2.rotateRight(n8, 5) - (n5 & ~n7) - (n6 & n7) - this.K[n3 + 3] & 0xFFFF;
            n7 = RC2.rotateRight(n7, 3) - (n8 & ~n6) - (n5 & n6) - this.K[n3 + 2] & 0xFFFF;
            n6 = RC2.rotateRight(n6, 2) - (n7 & ~n5) - (n8 & n5) - this.K[n3 + 1] & 0xFFFF;
            n5 = RC2.rotateRight(n5, 1) - (n6 & ~n8) - (n7 & n8) - this.K[n3 + 0] & 0xFFFF;
        }
        n8 = n8 - this.K[n7 & 0x3F] & 0xFFFF;
        n7 = n7 - this.K[n6 & 0x3F] & 0xFFFF;
        n6 = n6 - this.K[n5 & 0x3F] & 0xFFFF;
        n5 = n5 - this.K[n8 & 0x3F] & 0xFFFF;
        for (n4 = 10; n4 > 4; --n4) {
            n3 = n4 * 4;
            n8 = RC2.rotateRight(n8, 5) - (n5 & ~n7) - (n6 & n7) - this.K[n3 + 3] & 0xFFFF;
            n7 = RC2.rotateRight(n7, 3) - (n8 & ~n6) - (n5 & n6) - this.K[n3 + 2] & 0xFFFF;
            n6 = RC2.rotateRight(n6, 2) - (n7 & ~n5) - (n8 & n5) - this.K[n3 + 1] & 0xFFFF;
            n5 = RC2.rotateRight(n5, 1) - (n6 & ~n8) - (n7 & n8) - this.K[n3 + 0] & 0xFFFF;
        }
        n8 = n8 - this.K[n7 & 0x3F] & 0xFFFF;
        n7 = n7 - this.K[n6 & 0x3F] & 0xFFFF;
        n6 = n6 - this.K[n5 & 0x3F] & 0xFFFF;
        n5 = n5 - this.K[n8 & 0x3F] & 0xFFFF;
        for (n4 = 4; n4 >= 0; --n4) {
            n3 = n4 * 4;
            n8 = RC2.rotateRight(n8, 5) - (n5 & ~n7) - (n6 & n7) - this.K[n3 + 3] & 0xFFFF;
            n7 = RC2.rotateRight(n7, 3) - (n8 & ~n6) - (n5 & n6) - this.K[n3 + 2] & 0xFFFF;
            n6 = RC2.rotateRight(n6, 2) - (n7 & ~n5) - (n8 & n5) - this.K[n3 + 1] & 0xFFFF;
            n5 = RC2.rotateRight(n5, 1) - (n6 & ~n8) - (n7 & n8) - this.K[n3 + 0] & 0xFFFF;
        }
        RC2.putWordLSBO(n5, byArray2, n2 + 0);
        RC2.putWordLSBO(n6, byArray2, n2 + 2);
        RC2.putWordLSBO(n7, byArray2, n2 + 4);
        RC2.putWordLSBO(n8, byArray2, n2 + 6);
    }
}

