/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.asn1;

import com.mindbright.asn1.ASN1Boolean;
import com.mindbright.asn1.ASN1Choice;
import com.mindbright.asn1.ASN1Decoder;
import com.mindbright.asn1.ASN1Encoder;
import com.mindbright.asn1.ASN1Integer;
import com.mindbright.asn1.ASN1Object;
import com.mindbright.asn1.ASN1Set;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ASN1Structure
extends ASN1Object {
    protected StructComponent[] components;
    protected int count;
    protected Class ofType;

    protected ASN1Structure(int n) {
        this(n, 4);
    }

    protected ASN1Structure(int n, int n2) {
        super(n | 0x20);
        this.components = new StructComponent[n2];
        this.count = 0;
        this.ofType = null;
    }

    public int getCount() {
        return this.count;
    }

    public ASN1Object getComponent(int n) {
        ASN1Object aSN1Object = null;
        if (this.count > 0 && n < this.count) {
            aSN1Object = this.components[n].value;
        }
        return aSN1Object;
    }

    public ASN1Object getDistinctComponent(int n) {
        int n2;
        for (n2 = 0; n2 < this.count && n != this.components[n2].value.getTag(); ++n2) {
        }
        return this.getComponent(n2);
    }

    public boolean isOptional(int n) {
        boolean bl = false;
        if (this.count > 0 && n < this.count) {
            bl = this.components[n].isOptional;
        }
        return bl;
    }

    public ASN1Object getDefault(int n) {
        ASN1Object aSN1Object = null;
        if (this.count > 0 && n < this.count) {
            aSN1Object = this.components[n].defaultValue;
        }
        return aSN1Object;
    }

    public ASN1Object getDecodeComponent(int n, int n2) throws IOException {
        Class clazz = this.ofType();
        ASN1Object aSN1Object = null;
        if (clazz == null) {
            if (this instanceof ASN1Set) {
                aSN1Object = this.getDistinctComponent(n2);
            } else {
                boolean bl;
                aSN1Object = this.getComponent(n);
                int n3 = aSN1Object.getTag();
                boolean bl2 = bl = n3 == 0 || n3 == n2 || n3 == (n2 & 0xFFFFFFDF);
                if (aSN1Object != null) {
                    if (aSN1Object instanceof ASN1Choice) {
                        boolean bl3 = bl = ((ASN1Choice)aSN1Object).getMember(n2) != null;
                    }
                    if (!bl) {
                        aSN1Object = null;
                    }
                }
            }
            if (aSN1Object == null && !this.isOptional(n)) {
                throw new IOException("Error when decoding structure " + this.getType() + ", component not found (t=" + n2 + ", i=" + n + ")");
            }
        } else {
            try {
                aSN1Object = (ASN1Object)this.ofType().newInstance();
                this.addComponent(aSN1Object);
            }
            catch (Exception exception) {
                throw new IOException("Error when decoding structure " + this.getType() + ": " + exception.getMessage());
            }
        }
        return aSN1Object;
    }

    public void addComponent(ASN1Object aSN1Object) {
        this.addComponent(aSN1Object, null, false);
    }

    public void addComponent(ASN1Object aSN1Object, ASN1Object aSN1Object2, boolean bl) {
        if (this.count >= this.components.length) {
            StructComponent[] structComponentArray = this.components;
            this.components = new StructComponent[(structComponentArray.length + 1) * 2];
            System.arraycopy(structComponentArray, 0, this.components, 0, structComponentArray.length);
        }
        this.components[this.count++] = new StructComponent(aSN1Object, aSN1Object2, bl);
    }

    public void addOptional(ASN1Object aSN1Object) {
        this.addComponent(aSN1Object, null, true);
    }

    public void addOptional(ASN1Object aSN1Object, int n) {
        ASN1Integer aSN1Integer = new ASN1Integer();
        aSN1Integer.setValue(n);
        this.addComponent(aSN1Object, aSN1Integer, true);
    }

    public void addOptional(ASN1Object aSN1Object, boolean bl) {
        ASN1Boolean aSN1Boolean = new ASN1Boolean();
        aSN1Boolean.setValue(bl);
        this.addComponent(aSN1Object, aSN1Boolean, true);
    }

    public int encodeValue(ASN1Encoder aSN1Encoder, OutputStream outputStream) throws IOException {
        return aSN1Encoder.encodeStructure(outputStream, this);
    }

    public void decodeValue(ASN1Decoder aSN1Decoder, InputStream inputStream, int n) throws IOException {
        aSN1Decoder.decodeStructure(inputStream, n, this);
        this.setValue();
    }

    protected Class ofType() {
        return this.ofType;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ASN1Structure)) {
            return false;
        }
        ASN1Structure aSN1Structure = (ASN1Structure)object;
        if (this.count != aSN1Structure.getCount()) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.getComponent(i).equals(aSN1Structure.getComponent(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.count; ++i) {
            n += this.getComponent(i).hashCode();
        }
        return n;
    }

    private static class StructComponent {
        protected ASN1Object value;
        protected ASN1Object defaultValue;
        protected boolean isOptional;

        protected StructComponent(ASN1Object aSN1Object, ASN1Object aSN1Object2, boolean bl) {
            this.value = aSN1Object;
            this.defaultValue = aSN1Object2;
            this.isOptional = bl;
        }
    }
}

