/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.benchmark;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TLinkableAdaptor;
import gnu.trove.TLinkedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class MemoryUsage {
    public static long sizeOf(Creator creator) {
        long l = 0L;
        Object[] objectArray = new Object[100];
        try {
            Object object = creator.create();
            long l2 = MemoryUsage.getUsedMemory();
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = creator.create();
            }
            long l3 = MemoryUsage.getUsedMemory();
            float f = (float)(l3 - l2) / 100.0f;
            l = Math.round(f);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l;
    }

    private static long getUsedMemory() {
        MemoryUsage.gc();
        long l = Runtime.getRuntime().totalMemory();
        MemoryUsage.gc();
        long l2 = Runtime.getRuntime().freeMemory();
        long l3 = l - l2;
        return l3;
    }

    private static void gc() {
        try {
            System.gc();
            Thread.currentThread();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(100L);
            System.gc();
            Thread.currentThread();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            MemoryComparator memoryComparator = new MemoryComparator(new TroveSetCreator(), new JavasoftSetCreator(), "Compare size of Set implementation: 1,000 Integer objects measured in bytes");
            memoryComparator.compare();
            memoryComparator = null;
            MemoryComparator memoryComparator2 = new MemoryComparator(new TroveListCreator(), new JavasoftListCreator(), "Compare size of LinkedList implementation: 1,000 TLinkableAdaptor objects measured in bytes");
            memoryComparator2.compare();
            memoryComparator2 = null;
            MemoryComparator memoryComparator3 = new MemoryComparator(new TroveIntArrayListCreator(), new JavasoftIntegerArrayListCreator(), "Compare size of int/IntegerArrayList implementation: 1,000 ints measured in bytes");
            memoryComparator3.compare();
            memoryComparator3 = null;
            MemoryComparator memoryComparator4 = new MemoryComparator(new TroveMapCreator(), new JavasoftMapCreator(), "Compare size of Map implementation: 1,000 Integer->Integer mappings measured in bytes");
            memoryComparator4.compare();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    static class JavasoftListCreator
    implements Creator {
        JavasoftListCreator() {
        }

        public Object create() {
            LinkedList<TLinkableAdaptor> linkedList = new LinkedList<TLinkableAdaptor>();
            for (int i = 0; i < 1000; ++i) {
                TLinkableAdaptor tLinkableAdaptor = new TLinkableAdaptor();
                linkedList.add(tLinkableAdaptor);
            }
            return linkedList;
        }
    }

    static class TroveListCreator
    implements Creator {
        TroveListCreator() {
        }

        public Object create() {
            TLinkedList tLinkedList = new TLinkedList();
            for (int i = 0; i < 1000; ++i) {
                TLinkableAdaptor tLinkableAdaptor = new TLinkableAdaptor();
                tLinkedList.add(tLinkableAdaptor);
            }
            return tLinkedList;
        }
    }

    static class JavasoftSetCreator
    implements Creator {
        JavasoftSetCreator() {
        }

        public Object create() {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int i = 0; i < 1000; ++i) {
                Integer n = new Integer(i);
                hashSet.add(n);
            }
            return hashSet;
        }
    }

    static class TroveSetCreator
    implements Creator {
        TroveSetCreator() {
        }

        public Object create() {
            THashSet tHashSet = new THashSet();
            for (int i = 0; i < 1000; ++i) {
                Integer n = new Integer(i);
                tHashSet.add(n);
            }
            return tHashSet;
        }
    }

    static class JavasoftMapCreator
    implements Creator {
        JavasoftMapCreator() {
        }

        public Object create() {
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            for (int i = 0; i < 1000; ++i) {
                Integer n = new Integer(i);
                hashMap.put(n, n);
            }
            return hashMap;
        }
    }

    static class TroveMapCreator
    implements Creator {
        TroveMapCreator() {
        }

        public Object create() {
            THashMap tHashMap = new THashMap();
            for (int i = 0; i < 1000; ++i) {
                Integer n = new Integer(i);
                tHashMap.put(n, n);
            }
            return tHashMap;
        }
    }

    static class JavasoftIntegerArrayListCreator
    implements Creator {
        JavasoftIntegerArrayListCreator() {
        }

        public Object create() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < 1000; ++i) {
                Integer n = new Integer(i);
                arrayList.add(n);
            }
            arrayList.trimToSize();
            return arrayList;
        }
    }

    static class TroveIntArrayListCreator
    implements Creator {
        TroveIntArrayListCreator() {
        }

        public Object create() {
            TIntArrayList tIntArrayList = new TIntArrayList();
            for (int i = 0; i < 1000; ++i) {
                tIntArrayList.add(i);
            }
            tIntArrayList.trimToSize();
            return tIntArrayList;
        }
    }

    static interface Creator {
        public Object create();
    }

    static class MemoryComparator {
        Creator trove;
        Creator javasoft;
        String description;

        MemoryComparator(Creator creator, Creator creator2, String string) {
            this.trove = creator;
            this.javasoft = creator2;
            this.description = string;
        }

        public void compare() {
            MemoryUsage.gc();
            long l = MemoryUsage.sizeOf(this.javasoft);
            MemoryUsage.gc();
            long l2 = MemoryUsage.sizeOf(this.trove);
            long l3 = Math.round(l2 * 100L / l * 100L) / 100;
            System.out.println("--------------------------");
            System.out.println(this.description);
            System.out.println("javasoft: " + l);
            System.out.println("trove: " + l2);
            System.out.println("trove's collection requires " + l3 + "% of the memory needed by javasoft's collection");
        }
    }
}

