/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatFunction;
import gnu.trove.TFloatProcedure;
import gnu.trove.TObjectFloatIterator;
import gnu.trove.TObjectFloatProcedure;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TObjectFloatHashMap
extends TObjectHash
implements Serializable {
    protected transient float[] _values;

    public TObjectFloatHashMap() {
    }

    public TObjectFloatHashMap(int n) {
        super(n);
    }

    public TObjectFloatHashMap(int n, float f) {
        super(n, f);
    }

    public TObjectFloatHashMap(TObjectHashingStrategy tObjectHashingStrategy) {
        super(tObjectHashingStrategy);
    }

    public TObjectFloatHashMap(int n, TObjectHashingStrategy tObjectHashingStrategy) {
        super(n, tObjectHashingStrategy);
    }

    public TObjectFloatHashMap(int n, float f, TObjectHashingStrategy tObjectHashingStrategy) {
        super(n, f, tObjectHashingStrategy);
    }

    public TObjectFloatIterator iterator() {
        return new TObjectFloatIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new float[n2];
        return n2;
    }

    public float put(Object object, float f) {
        float f2 = 0.0f;
        int n = this.insertionIndex(object);
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            f2 = this._values[n];
            bl = false;
        }
        Object object2 = this._set[n];
        this._set[n] = object;
        this._values[n] = f;
        if (bl) {
            this.postInsertHook(object2 == null);
        }
        return f2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        Object[] objectArray = this._set;
        float[] fArray = this._values;
        this._set = new Object[n];
        this._values = new float[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (objectArray[n3] == null || objectArray[n3] == REMOVED) continue;
            Object object = objectArray[n3];
            int n4 = this.insertionIndex(object);
            if (n4 < 0) {
                this.throwObjectContractViolation(this._set[-n4 - 1], object);
            }
            this._set[n4] = object;
            this._values[n4] = fArray[n3];
        }
    }

    public float get(Object object) {
        int n = this.index(object);
        return n < 0 ? 0.0f : this._values[n];
    }

    public void clear() {
        super.clear();
        Object[] objectArray = this._set;
        float[] fArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            objectArray[n] = null;
            fArray[n] = 0.0f;
        }
    }

    public float remove(Object object) {
        float f = 0.0f;
        int n = this.index(object);
        if (n >= 0) {
            f = this._values[n];
            this.removeAt(n);
        }
        return f;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TObjectFloatHashMap)) {
            return false;
        }
        TObjectFloatHashMap tObjectFloatHashMap = (TObjectFloatHashMap)object;
        if (tObjectFloatHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tObjectFloatHashMap));
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0.0f;
    }

    public float[] getValues() {
        float[] fArray = new float[this.size()];
        float[] fArray2 = this._values;
        Object[] objectArray = this._set;
        int n = fArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED) continue;
            fArray[n2++] = fArray2[n];
        }
        return fArray;
    }

    public Object[] keys() {
        Object[] objectArray = new Object[this.size()];
        Object[] objectArray2 = this._set;
        int n = objectArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (objectArray2[n] == null || objectArray2[n] == REMOVED) continue;
            objectArray[n2++] = objectArray2[n];
        }
        return objectArray;
    }

    public boolean containsValue(float f) {
        Object[] objectArray = this._set;
        float[] fArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || f != fArray[n]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object object) {
        return this.contains(object);
    }

    public boolean forEachKey(TObjectProcedure tObjectProcedure) {
        return this.forEach(tObjectProcedure);
    }

    public boolean forEachValue(TFloatProcedure tFloatProcedure) {
        Object[] objectArray = this._set;
        float[] fArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || tFloatProcedure.execute(fArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectFloatProcedure tObjectFloatProcedure) {
        Object[] objectArray = this._set;
        float[] fArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || tObjectFloatProcedure.execute(objectArray[n], fArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TObjectFloatProcedure tObjectFloatProcedure) {
        boolean bl = false;
        Object[] objectArray = this._set;
        float[] fArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || tObjectFloatProcedure.execute(objectArray[n], fArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TFloatFunction tFloatFunction) {
        Object[] objectArray = this._set;
        float[] fArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED) continue;
            fArray[n] = tFloatFunction.execute(fArray[n]);
        }
    }

    public boolean increment(Object object) {
        return this.adjustValue(object, 1.0f);
    }

    public boolean adjustValue(Object object, float f) {
        int n = this.index(object);
        if (n < 0) {
            return false;
        }
        int n2 = n;
        this._values[n2] = this._values[n2] + f;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            Object object = objectInputStream.readObject();
            float f = objectInputStream.readFloat();
            this.put(object, f);
        }
    }

    private static final class EqProcedure
    implements TObjectFloatProcedure {
        private final TObjectFloatHashMap _otherMap;

        EqProcedure(TObjectFloatHashMap tObjectFloatHashMap) {
            this._otherMap = tObjectFloatHashMap;
        }

        public final boolean execute(Object object, float f) {
            int n = this._otherMap.index(object);
            return n >= 0 && this.eq(f, this._otherMap.get(object));
        }

        private final boolean eq(float f, float f2) {
            return f == f2;
        }
    }
}

