/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatFunction;
import gnu.trove.TFloatProcedure;
import gnu.trove.TLongFloatIterator;
import gnu.trove.TLongFloatProcedure;
import gnu.trove.TLongHash;
import gnu.trove.TLongHashingStrategy;
import gnu.trove.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TLongFloatHashMap
extends TLongHash
implements Serializable {
    protected transient float[] _values;

    public TLongFloatHashMap() {
    }

    public TLongFloatHashMap(int n) {
        super(n);
    }

    public TLongFloatHashMap(int n, float f) {
        super(n, f);
    }

    public TLongFloatHashMap(TLongHashingStrategy tLongHashingStrategy) {
        super(tLongHashingStrategy);
    }

    public TLongFloatHashMap(int n, TLongHashingStrategy tLongHashingStrategy) {
        super(n, tLongHashingStrategy);
    }

    public TLongFloatHashMap(int n, float f, TLongHashingStrategy tLongHashingStrategy) {
        super(n, f, tLongHashingStrategy);
    }

    public Object clone() {
        TLongFloatHashMap tLongFloatHashMap = (TLongFloatHashMap)super.clone();
        tLongFloatHashMap._values = (float[])this._values.clone();
        return tLongFloatHashMap;
    }

    public TLongFloatIterator iterator() {
        return new TLongFloatIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new float[n2];
        return n2;
    }

    public float put(long l, float f) {
        float f2 = 0.0f;
        int n = this.insertionIndex(l);
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            f2 = this._values[n];
            bl = false;
        }
        byte by = this._states[n];
        this._set[n] = l;
        this._states[n] = 1;
        this._values[n] = f;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return f2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        long[] lArray = this._set;
        float[] fArray = this._values;
        byte[] byArray = this._states;
        this._set = new long[n];
        this._values = new float[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            long l = lArray[n3];
            int n4 = this.insertionIndex(l);
            this._set[n4] = l;
            this._values[n4] = fArray[n3];
            this._states[n4] = 1;
        }
    }

    public float get(long l) {
        int n = this.index(l);
        return n < 0 ? 0.0f : this._values[n];
    }

    public void clear() {
        super.clear();
        long[] lArray = this._set;
        float[] fArray = this._values;
        byte[] byArray = this._states;
        int n = lArray.length;
        while (n-- > 0) {
            lArray[n] = 0L;
            fArray[n] = 0.0f;
            byArray[n] = 0;
        }
    }

    public float remove(long l) {
        float f = 0.0f;
        int n = this.index(l);
        if (n >= 0) {
            f = this._values[n];
            this.removeAt(n);
        }
        return f;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLongFloatHashMap)) {
            return false;
        }
        TLongFloatHashMap tLongFloatHashMap = (TLongFloatHashMap)object;
        if (tLongFloatHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tLongFloatHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0.0f;
    }

    public float[] getValues() {
        float[] fArray = new float[this.size()];
        float[] fArray2 = this._values;
        byte[] byArray = this._states;
        int n = fArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            fArray[n2++] = fArray2[n];
        }
        return fArray;
    }

    public long[] keys() {
        long[] lArray = new long[this.size()];
        long[] lArray2 = this._set;
        byte[] byArray = this._states;
        int n = lArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n2++] = lArray2[n];
        }
        return lArray;
    }

    public boolean containsValue(float f) {
        byte[] byArray = this._states;
        float[] fArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || f != fArray[n]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(long l) {
        return this.contains(l);
    }

    public boolean forEachKey(TLongProcedure tLongProcedure) {
        return this.forEach(tLongProcedure);
    }

    public boolean forEachValue(TFloatProcedure tFloatProcedure) {
        byte[] byArray = this._states;
        float[] fArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tFloatProcedure.execute(fArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TLongFloatProcedure tLongFloatProcedure) {
        byte[] byArray = this._states;
        long[] lArray = this._set;
        float[] fArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongFloatProcedure.execute(lArray[n], fArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TLongFloatProcedure tLongFloatProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        long[] lArray = this._set;
        float[] fArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongFloatProcedure.execute(lArray[n], fArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TFloatFunction tFloatFunction) {
        byte[] byArray = this._states;
        float[] fArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            fArray[n] = tFloatFunction.execute(fArray[n]);
        }
    }

    public boolean increment(long l) {
        return this.adjustValue(l, 1.0f);
    }

    public boolean adjustValue(long l, float f) {
        int n = this.index(l);
        if (n < 0) {
            return false;
        }
        int n2 = n;
        this._values[n2] = this._values[n2] + f;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            long l = objectInputStream.readLong();
            float f = objectInputStream.readFloat();
            this.put(l, f);
        }
    }

    private static final class EqProcedure
    implements TLongFloatProcedure {
        private final TLongFloatHashMap _otherMap;

        EqProcedure(TLongFloatHashMap tLongFloatHashMap) {
            this._otherMap = tLongFloatHashMap;
        }

        public final boolean execute(long l, float f) {
            int n = this._otherMap.index(l);
            return n >= 0 && this.eq(f, this._otherMap.get(l));
        }

        private final boolean eq(float f, float f2) {
            return f == f2;
        }
    }

    private final class HashProcedure
    implements TLongFloatProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(long l, float f) {
            this.h += TLongFloatHashMap.this._hashingStrategy.computeHashCode(l) ^ HashFunctions.hash(f);
            return true;
        }
    }
}

