/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TLongFunction;
import gnu.trove.TLongProcedure;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class TLongArrayList
implements Serializable,
Cloneable {
    protected long[] _data;
    protected int _pos;
    protected static final int DEFAULT_CAPACITY = 10;

    public TLongArrayList() {
        this(10);
    }

    public TLongArrayList(int n) {
        this._data = new long[n];
        this._pos = 0;
    }

    public TLongArrayList(long[] lArray) {
        this(Math.max(lArray.length, 10));
        this.add(lArray);
    }

    public void ensureCapacity(int n) {
        if (n > this._data.length) {
            int n2 = Math.max(this._data.length << 1, n);
            long[] lArray = new long[n2];
            System.arraycopy(this._data, 0, lArray, 0, this._data.length);
            this._data = lArray;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data.length > this.size()) {
            long[] lArray = new long[this.size()];
            this.toNativeArray(lArray, 0, lArray.length);
            this._data = lArray;
        }
    }

    public void add(long l) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = l;
    }

    public void add(long[] lArray) {
        this.add(lArray, 0, lArray.length);
    }

    public void add(long[] lArray, int n, int n2) {
        this.ensureCapacity(this._pos + n2);
        System.arraycopy(lArray, n, this._data, this._pos, n2);
        this._pos += n2;
    }

    public void insert(int n, long l) {
        if (n == this._pos) {
            this.add(l);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, n, this._data, n + 1, this._pos - n);
        this._data[n] = l;
        ++this._pos;
    }

    public void insert(int n, long[] lArray) {
        this.insert(n, lArray, 0, lArray.length);
    }

    public void insert(int n, long[] lArray, int n2, int n3) {
        if (n == this._pos) {
            this.add(lArray, n2, n3);
            return;
        }
        this.ensureCapacity(this._pos + n3);
        System.arraycopy(this._data, n, this._data, n + n3, this._pos - n);
        System.arraycopy(lArray, n2, this._data, n, n3);
        this._pos += n3;
    }

    public long get(int n) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this._data[n];
    }

    public long getQuick(int n) {
        return this._data[n];
    }

    public void set(int n, long l) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this._data[n] = l;
    }

    public long getSet(int n, long l) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        long l2 = this._data[n];
        this._data[n] = l;
        return l2;
    }

    public void set(int n, long[] lArray) {
        this.set(n, lArray, 0, lArray.length);
    }

    public void set(int n, long[] lArray, int n2, int n3) {
        if (n < 0 || n + n3 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        System.arraycopy(lArray, n2, this._data, n, n3);
    }

    public void setQuick(int n, long l) {
        this._data[n] = l;
    }

    public void clear() {
        this.clear(10);
    }

    public void clear(int n) {
        this._data = new long[n];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
        this.fill(0L);
    }

    public void resetQuick() {
        this._pos = 0;
    }

    public long remove(int n) {
        long l = this.get(n);
        this.remove(n, 1);
        return l;
    }

    public void remove(int n, int n2) {
        if (n < 0 || n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n == 0) {
            System.arraycopy(this._data, n2, this._data, 0, this._pos - n2);
        } else if (this._pos - n2 != n) {
            System.arraycopy(this._data, n + n2, this._data, n, this._pos - (n + n2));
        }
        this._pos -= n2;
    }

    public void transformValues(TLongFunction tLongFunction) {
        int n = this._pos;
        while (n-- > 0) {
            this._data[n] = tLongFunction.execute(this._data[n]);
        }
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (n > n2) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int n3 = n;
        for (int i = n2 - 1; n3 < i; ++n3, --i) {
            this.swap(n3, i);
        }
    }

    public void shuffle(Random random) {
        int n = this._pos;
        while (n-- > 1) {
            this.swap(n, random.nextInt(n));
        }
    }

    private final void swap(int n, int n2) {
        long l = this._data[n];
        this._data[n] = this._data[n2];
        this._data[n2] = l;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public long[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public long[] toNativeArray(int n, int n2) {
        long[] lArray = new long[n2];
        this.toNativeArray(lArray, n, n2);
        return lArray;
    }

    public void toNativeArray(long[] lArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        System.arraycopy(this._data, 0, lArray, n, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TLongArrayList) {
            TLongArrayList tLongArrayList = (TLongArrayList)object;
            if (tLongArrayList.size() != this.size()) {
                return false;
            }
            int n = this._pos;
            while (n-- > 0) {
                if (this._data[n] == tLongArrayList._data[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this._pos;
        while (n2-- > 0) {
            n += HashFunctions.hash(this._data[n2]);
        }
        return n;
    }

    public boolean forEach(TLongProcedure tLongProcedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (tLongProcedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachDescending(TLongProcedure tLongProcedure) {
        int n = this._pos;
        while (n-- > 0) {
            if (tLongProcedure.execute(this._data[n])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        Arrays.sort(this._data, 0, this._pos);
    }

    public void sort(int n, int n2) {
        Arrays.sort(this._data, n, n2);
    }

    public void fill(long l) {
        Arrays.fill(this._data, 0, this._pos, l);
    }

    public void fill(int n, int n2, long l) {
        if (n2 > this._pos) {
            this.ensureCapacity(n2);
            this._pos = n2;
        }
        Arrays.fill(this._data, n, n2, l);
    }

    public int binarySearch(long l) {
        return this.binarySearch(l, 0, this._pos);
    }

    public int binarySearch(long l, int n, int n2) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n2 > this._pos) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >> 1;
            long l2 = this._data[n5];
            if (l2 < l) {
                n3 = n5 + 1;
                continue;
            }
            if (l2 > l) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public int indexOf(long l) {
        return this.indexOf(0, l);
    }

    public int indexOf(int n, long l) {
        for (int i = n; i < this._pos; ++i) {
            if (this._data[i] != l) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long l) {
        return this.lastIndexOf(this._pos, l);
    }

    public int lastIndexOf(int n, long l) {
        int n2 = n;
        while (n2-- > 0) {
            if (this._data[n2] != l) continue;
            return n2;
        }
        return -1;
    }

    public boolean contains(long l) {
        return this.lastIndexOf(l) >= 0;
    }

    public TLongArrayList grep(TLongProcedure tLongProcedure) {
        TLongArrayList tLongArrayList = new TLongArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (!tLongProcedure.execute(this._data[i])) continue;
            tLongArrayList.add(this._data[i]);
        }
        return tLongArrayList;
    }

    public TLongArrayList inverseGrep(TLongProcedure tLongProcedure) {
        TLongArrayList tLongArrayList = new TLongArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (tLongProcedure.execute(this._data[i])) continue;
            tLongArrayList.add(this._data[i]);
        }
        return tLongArrayList;
    }

    public long max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        long l = this._data[this._pos - 1];
        int n = this._pos - 1;
        while (n-- > 0) {
            if (this._data[n] <= l) continue;
            l = this._data[n];
        }
        return l;
    }

    public long min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        long l = this._data[this._pos - 1];
        int n = this._pos - 1;
        while (n-- > 0) {
            if (this._data[n] >= l) continue;
            l = this._data[n];
        }
        return l;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = this._pos - 1;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this._data[i]);
            stringBuffer.append(", ");
        }
        if (this.size() > 0) {
            stringBuffer.append(this._data[this._pos - 1]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

