/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleFunction;
import gnu.trove.TDoubleProcedure;
import gnu.trove.TIntDoubleIterator;
import gnu.trove.TIntDoubleProcedure;
import gnu.trove.TIntHash;
import gnu.trove.TIntHashingStrategy;
import gnu.trove.TIntProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TIntDoubleHashMap
extends TIntHash
implements Serializable {
    protected transient double[] _values;

    public TIntDoubleHashMap() {
    }

    public TIntDoubleHashMap(int n) {
        super(n);
    }

    public TIntDoubleHashMap(int n, float f) {
        super(n, f);
    }

    public TIntDoubleHashMap(TIntHashingStrategy tIntHashingStrategy) {
        super(tIntHashingStrategy);
    }

    public TIntDoubleHashMap(int n, TIntHashingStrategy tIntHashingStrategy) {
        super(n, tIntHashingStrategy);
    }

    public TIntDoubleHashMap(int n, float f, TIntHashingStrategy tIntHashingStrategy) {
        super(n, f, tIntHashingStrategy);
    }

    public Object clone() {
        TIntDoubleHashMap tIntDoubleHashMap = (TIntDoubleHashMap)super.clone();
        tIntDoubleHashMap._values = (double[])this._values.clone();
        return tIntDoubleHashMap;
    }

    public TIntDoubleIterator iterator() {
        return new TIntDoubleIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new double[n2];
        return n2;
    }

    public double put(int n, double d) {
        double d2 = 0.0;
        int n2 = this.insertionIndex(n);
        boolean bl = true;
        if (n2 < 0) {
            n2 = -n2 - 1;
            d2 = this._values[n2];
            bl = false;
        }
        byte by = this._states[n2];
        this._set[n2] = n;
        this._states[n2] = 1;
        this._values[n2] = d;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return d2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        int[] nArray = this._set;
        double[] dArray = this._values;
        byte[] byArray = this._states;
        this._set = new int[n];
        this._values = new double[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            int n4 = nArray[n3];
            int n5 = this.insertionIndex(n4);
            this._set[n5] = n4;
            this._values[n5] = dArray[n3];
            this._states[n5] = 1;
        }
    }

    public double get(int n) {
        int n2 = this.index(n);
        return n2 < 0 ? 0.0 : this._values[n2];
    }

    public void clear() {
        super.clear();
        int[] nArray = this._set;
        double[] dArray = this._values;
        byte[] byArray = this._states;
        int n = nArray.length;
        while (n-- > 0) {
            nArray[n] = 0;
            dArray[n] = 0.0;
            byArray[n] = 0;
        }
    }

    public double remove(int n) {
        double d = 0.0;
        int n2 = this.index(n);
        if (n2 >= 0) {
            d = this._values[n2];
            this.removeAt(n2);
        }
        return d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TIntDoubleHashMap)) {
            return false;
        }
        TIntDoubleHashMap tIntDoubleHashMap = (TIntDoubleHashMap)object;
        if (tIntDoubleHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tIntDoubleHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0.0;
    }

    public double[] getValues() {
        double[] dArray = new double[this.size()];
        double[] dArray2 = this._values;
        byte[] byArray = this._states;
        int n = dArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            dArray[n2++] = dArray2[n];
        }
        return dArray;
    }

    public int[] keys() {
        int[] nArray = new int[this.size()];
        int[] nArray2 = this._set;
        byte[] byArray = this._states;
        int n = nArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n2++] = nArray2[n];
        }
        return nArray;
    }

    public boolean containsValue(double d) {
        byte[] byArray = this._states;
        double[] dArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || d != dArray[n]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(int n) {
        return this.contains(n);
    }

    public boolean forEachKey(TIntProcedure tIntProcedure) {
        return this.forEach(tIntProcedure);
    }

    public boolean forEachValue(TDoubleProcedure tDoubleProcedure) {
        byte[] byArray = this._states;
        double[] dArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tDoubleProcedure.execute(dArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TIntDoubleProcedure tIntDoubleProcedure) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        double[] dArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntDoubleProcedure.execute(nArray[n], dArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TIntDoubleProcedure tIntDoubleProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        int[] nArray = this._set;
        double[] dArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntDoubleProcedure.execute(nArray[n], dArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TDoubleFunction tDoubleFunction) {
        byte[] byArray = this._states;
        double[] dArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            dArray[n] = tDoubleFunction.execute(dArray[n]);
        }
    }

    public boolean increment(int n) {
        return this.adjustValue(n, 1.0);
    }

    public boolean adjustValue(int n, double d) {
        int n2 = this.index(n);
        if (n2 < 0) {
            return false;
        }
        int n3 = n2;
        this._values[n3] = this._values[n3] + d;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            int n2 = objectInputStream.readInt();
            double d = objectInputStream.readDouble();
            this.put(n2, d);
        }
    }

    private static final class EqProcedure
    implements TIntDoubleProcedure {
        private final TIntDoubleHashMap _otherMap;

        EqProcedure(TIntDoubleHashMap tIntDoubleHashMap) {
            this._otherMap = tIntDoubleHashMap;
        }

        public final boolean execute(int n, double d) {
            int n2 = this._otherMap.index(n);
            return n2 >= 0 && this.eq(d, this._otherMap.get(n));
        }

        private final boolean eq(double d, double d2) {
            return d == d2;
        }
    }

    private final class HashProcedure
    implements TIntDoubleProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(int n, double d) {
            this.h += TIntDoubleHashMap.this._hashingStrategy.computeHashCode(n) ^ HashFunctions.hash(d);
            return true;
        }
    }
}

