/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashIterator;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import gnu.trove.ToObjectArrayProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class THashSet
extends TObjectHash
implements Set,
Serializable {
    public THashSet() {
    }

    public THashSet(TObjectHashingStrategy tObjectHashingStrategy) {
        super(tObjectHashingStrategy);
    }

    public THashSet(int n) {
        super(n);
    }

    public THashSet(int n, TObjectHashingStrategy tObjectHashingStrategy) {
        super(n, tObjectHashingStrategy);
    }

    public THashSet(int n, float f) {
        super(n, f);
    }

    public THashSet(int n, float f, TObjectHashingStrategy tObjectHashingStrategy) {
        super(n, f, tObjectHashingStrategy);
    }

    public THashSet(Collection collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public THashSet(Collection collection, TObjectHashingStrategy tObjectHashingStrategy) {
        this(collection.size(), tObjectHashingStrategy);
        this.addAll(collection);
    }

    public boolean add(Object object) {
        int n = this.insertionIndex(object);
        if (n < 0) {
            return false;
        }
        Object object2 = this._set[n];
        this._set[n] = object;
        this.postInsertHook(object2 == null);
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (set.size() != this.size()) {
            return false;
        }
        return this.containsAll((Collection)set);
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEach(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        Object[] objectArray = this._set;
        this._set = new Object[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (objectArray[n3] == null || objectArray[n3] == REMOVED) continue;
            Object object = objectArray[n3];
            int n4 = this.insertionIndex(object);
            if (n4 < 0) {
                this.throwObjectContractViolation(this._set[-n4 - 1], object);
            }
            this._set[n4] = object;
        }
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        this.forEach(new ToObjectArrayProcedure(objectArray));
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        this.forEach(new ToObjectArrayProcedure(objectArray));
        Iterator iterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = iterator.next();
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public void clear() {
        super.clear();
        Object[] objectArray = this._set;
        int n = objectArray.length;
        while (n-- > 0) {
            objectArray[n] = null;
        }
    }

    public boolean remove(Object object) {
        int n = this.index(object);
        if (n >= 0) {
            this.removeAt(n);
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return new TObjectHashIterator(this);
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        int n = collection.size();
        this.ensureCapacity(n);
        Iterator iterator = collection.iterator();
        while (n-- > 0) {
            if (!this.add(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        int n = collection.size();
        Iterator iterator = collection.iterator();
        while (n-- > 0) {
            if (!this.remove(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        int n = this.size();
        Iterator iterator = this.iterator();
        while (n-- > 0) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEach(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            Object object = objectInputStream.readObject();
            this.add(object);
        }
    }

    private final class HashProcedure
    implements TObjectProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(Object object) {
            this.h += THashSet.this._hashingStrategy.computeHashCode(object);
            return true;
        }
    }
}

