/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TIterator;
import gnu.trove.TObjectHash;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

abstract class THashIterator
extends TIterator
implements Iterator {
    protected final TObjectHash _hash;

    public THashIterator(TObjectHash tObjectHash) {
        super(tObjectHash);
        this._hash = tObjectHash;
    }

    public Object next() {
        this.moveToNextIndex();
        return this.objectAtIndex(this._index);
    }

    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] objectArray = this._hash._set;
        int n = this._index;
        while (n-- > 0 && (objectArray[n] == null || objectArray[n] == TObjectHash.REMOVED)) {
        }
        return n;
    }

    protected abstract Object objectAtIndex(int var1);
}

