/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatHash;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatLongIterator;
import gnu.trove.TFloatLongProcedure;
import gnu.trove.TFloatProcedure;
import gnu.trove.TLongFunction;
import gnu.trove.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TFloatLongHashMap
extends TFloatHash
implements Serializable {
    protected transient long[] _values;

    public TFloatLongHashMap() {
    }

    public TFloatLongHashMap(int n) {
        super(n);
    }

    public TFloatLongHashMap(int n, float f) {
        super(n, f);
    }

    public TFloatLongHashMap(TFloatHashingStrategy tFloatHashingStrategy) {
        super(tFloatHashingStrategy);
    }

    public TFloatLongHashMap(int n, TFloatHashingStrategy tFloatHashingStrategy) {
        super(n, tFloatHashingStrategy);
    }

    public TFloatLongHashMap(int n, float f, TFloatHashingStrategy tFloatHashingStrategy) {
        super(n, f, tFloatHashingStrategy);
    }

    public Object clone() {
        TFloatLongHashMap tFloatLongHashMap = (TFloatLongHashMap)super.clone();
        tFloatLongHashMap._values = (long[])this._values.clone();
        return tFloatLongHashMap;
    }

    public TFloatLongIterator iterator() {
        return new TFloatLongIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new long[n2];
        return n2;
    }

    public long put(float f, long l) {
        long l2 = 0L;
        int n = this.insertionIndex(f);
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            l2 = this._values[n];
            bl = false;
        }
        byte by = this._states[n];
        this._set[n] = f;
        this._states[n] = 1;
        this._values[n] = l;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return l2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        float[] fArray = this._set;
        long[] lArray = this._values;
        byte[] byArray = this._states;
        this._set = new float[n];
        this._values = new long[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            float f = fArray[n3];
            int n4 = this.insertionIndex(f);
            this._set[n4] = f;
            this._values[n4] = lArray[n3];
            this._states[n4] = 1;
        }
    }

    public long get(float f) {
        int n = this.index(f);
        return n < 0 ? 0L : this._values[n];
    }

    public void clear() {
        super.clear();
        float[] fArray = this._set;
        long[] lArray = this._values;
        byte[] byArray = this._states;
        int n = fArray.length;
        while (n-- > 0) {
            fArray[n] = 0.0f;
            lArray[n] = 0L;
            byArray[n] = 0;
        }
    }

    public long remove(float f) {
        long l = 0L;
        int n = this.index(f);
        if (n >= 0) {
            l = this._values[n];
            this.removeAt(n);
        }
        return l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TFloatLongHashMap)) {
            return false;
        }
        TFloatLongHashMap tFloatLongHashMap = (TFloatLongHashMap)object;
        if (tFloatLongHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tFloatLongHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0L;
    }

    public long[] getValues() {
        long[] lArray = new long[this.size()];
        long[] lArray2 = this._values;
        byte[] byArray = this._states;
        int n = lArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n2++] = lArray2[n];
        }
        return lArray;
    }

    public float[] keys() {
        float[] fArray = new float[this.size()];
        float[] fArray2 = this._set;
        byte[] byArray = this._states;
        int n = fArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            fArray[n2++] = fArray2[n];
        }
        return fArray;
    }

    public boolean containsValue(long l) {
        byte[] byArray = this._states;
        long[] lArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || l != lArray[n]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(float f) {
        return this.contains(f);
    }

    public boolean forEachKey(TFloatProcedure tFloatProcedure) {
        return this.forEach(tFloatProcedure);
    }

    public boolean forEachValue(TLongProcedure tLongProcedure) {
        byte[] byArray = this._states;
        long[] lArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongProcedure.execute(lArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TFloatLongProcedure tFloatLongProcedure) {
        byte[] byArray = this._states;
        float[] fArray = this._set;
        long[] lArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tFloatLongProcedure.execute(fArray[n], lArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TFloatLongProcedure tFloatLongProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        float[] fArray = this._set;
        long[] lArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tFloatLongProcedure.execute(fArray[n], lArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TLongFunction tLongFunction) {
        byte[] byArray = this._states;
        long[] lArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n] = tLongFunction.execute(lArray[n]);
        }
    }

    public boolean increment(float f) {
        return this.adjustValue(f, 1L);
    }

    public boolean adjustValue(float f, long l) {
        int n = this.index(f);
        if (n < 0) {
            return false;
        }
        int n2 = n;
        this._values[n2] = this._values[n2] + l;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            float f = objectInputStream.readFloat();
            long l = objectInputStream.readLong();
            this.put(f, l);
        }
    }

    private static final class EqProcedure
    implements TFloatLongProcedure {
        private final TFloatLongHashMap _otherMap;

        EqProcedure(TFloatLongHashMap tFloatLongHashMap) {
            this._otherMap = tFloatLongHashMap;
        }

        public final boolean execute(float f, long l) {
            int n = this._otherMap.index(f);
            return n >= 0 && this.eq(l, this._otherMap.get(f));
        }

        private final boolean eq(long l, long l2) {
            return l == l2;
        }
    }

    private final class HashProcedure
    implements TFloatLongProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(float f, long l) {
            this.h += TFloatLongHashMap.this._hashingStrategy.computeHashCode(f) ^ HashFunctions.hash(l);
            return true;
        }
    }
}

