/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatHash;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatIntIterator;
import gnu.trove.TFloatIntProcedure;
import gnu.trove.TFloatProcedure;
import gnu.trove.TIntFunction;
import gnu.trove.TIntProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TFloatIntHashMap
extends TFloatHash
implements Serializable {
    protected transient int[] _values;

    public TFloatIntHashMap() {
    }

    public TFloatIntHashMap(int n) {
        super(n);
    }

    public TFloatIntHashMap(int n, float f) {
        super(n, f);
    }

    public TFloatIntHashMap(TFloatHashingStrategy tFloatHashingStrategy) {
        super(tFloatHashingStrategy);
    }

    public TFloatIntHashMap(int n, TFloatHashingStrategy tFloatHashingStrategy) {
        super(n, tFloatHashingStrategy);
    }

    public TFloatIntHashMap(int n, float f, TFloatHashingStrategy tFloatHashingStrategy) {
        super(n, f, tFloatHashingStrategy);
    }

    public Object clone() {
        TFloatIntHashMap tFloatIntHashMap = (TFloatIntHashMap)super.clone();
        tFloatIntHashMap._values = (int[])this._values.clone();
        return tFloatIntHashMap;
    }

    public TFloatIntIterator iterator() {
        return new TFloatIntIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new int[n2];
        return n2;
    }

    public int put(float f, int n) {
        int n2 = 0;
        int n3 = this.insertionIndex(f);
        boolean bl = true;
        if (n3 < 0) {
            n3 = -n3 - 1;
            n2 = this._values[n3];
            bl = false;
        }
        byte by = this._states[n3];
        this._set[n3] = f;
        this._states[n3] = 1;
        this._values[n3] = n;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return n2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        float[] fArray = this._set;
        int[] nArray = this._values;
        byte[] byArray = this._states;
        this._set = new float[n];
        this._values = new int[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            float f = fArray[n3];
            int n4 = this.insertionIndex(f);
            this._set[n4] = f;
            this._values[n4] = nArray[n3];
            this._states[n4] = 1;
        }
    }

    public int get(float f) {
        int n = this.index(f);
        return n < 0 ? 0 : this._values[n];
    }

    public void clear() {
        super.clear();
        float[] fArray = this._set;
        int[] nArray = this._values;
        byte[] byArray = this._states;
        int n = fArray.length;
        while (n-- > 0) {
            fArray[n] = 0.0f;
            nArray[n] = 0;
            byArray[n] = 0;
        }
    }

    public int remove(float f) {
        int n = 0;
        int n2 = this.index(f);
        if (n2 >= 0) {
            n = this._values[n2];
            this.removeAt(n2);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TFloatIntHashMap)) {
            return false;
        }
        TFloatIntHashMap tFloatIntHashMap = (TFloatIntHashMap)object;
        if (tFloatIntHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tFloatIntHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0;
    }

    public int[] getValues() {
        int[] nArray = new int[this.size()];
        int[] nArray2 = this._values;
        byte[] byArray = this._states;
        int n = nArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n2++] = nArray2[n];
        }
        return nArray;
    }

    public float[] keys() {
        float[] fArray = new float[this.size()];
        float[] fArray2 = this._set;
        byte[] byArray = this._states;
        int n = fArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            fArray[n2++] = fArray2[n];
        }
        return fArray;
    }

    public boolean containsValue(int n) {
        byte[] byArray = this._states;
        int[] nArray = this._values;
        int n2 = nArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1 || n != nArray[n2]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(float f) {
        return this.contains(f);
    }

    public boolean forEachKey(TFloatProcedure tFloatProcedure) {
        return this.forEach(tFloatProcedure);
    }

    public boolean forEachValue(TIntProcedure tIntProcedure) {
        byte[] byArray = this._states;
        int[] nArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntProcedure.execute(nArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TFloatIntProcedure tFloatIntProcedure) {
        byte[] byArray = this._states;
        float[] fArray = this._set;
        int[] nArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tFloatIntProcedure.execute(fArray[n], nArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TFloatIntProcedure tFloatIntProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        float[] fArray = this._set;
        int[] nArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tFloatIntProcedure.execute(fArray[n], nArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TIntFunction tIntFunction) {
        byte[] byArray = this._states;
        int[] nArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n] = tIntFunction.execute(nArray[n]);
        }
    }

    public boolean increment(float f) {
        return this.adjustValue(f, 1);
    }

    public boolean adjustValue(float f, int n) {
        int n2 = this.index(f);
        if (n2 < 0) {
            return false;
        }
        int n3 = n2;
        this._values[n3] = this._values[n3] + n;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            float f = objectInputStream.readFloat();
            int n2 = objectInputStream.readInt();
            this.put(f, n2);
        }
    }

    private static final class EqProcedure
    implements TFloatIntProcedure {
        private final TFloatIntHashMap _otherMap;

        EqProcedure(TFloatIntHashMap tFloatIntHashMap) {
            this._otherMap = tFloatIntHashMap;
        }

        public final boolean execute(float f, int n) {
            int n2 = this._otherMap.index(f);
            return n2 >= 0 && this.eq(n, this._otherMap.get(f));
        }

        private final boolean eq(int n, int n2) {
            return n == n2;
        }
    }

    private final class HashProcedure
    implements TFloatIntProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(float f, int n) {
            this.h += TFloatIntHashMap.this._hashingStrategy.computeHashCode(f) ^ HashFunctions.hash(n);
            return true;
        }
    }
}

