/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatProcedure;
import gnu.trove.TPrimitiveHash;
import java.io.Serializable;

public abstract class TFloatHash
extends TPrimitiveHash
implements Serializable,
TFloatHashingStrategy {
    protected transient float[] _set;
    protected TFloatHashingStrategy _hashingStrategy;

    public TFloatHash() {
        this._hashingStrategy = this;
    }

    public TFloatHash(int n) {
        super(n);
        this._hashingStrategy = this;
    }

    public TFloatHash(int n, float f) {
        super(n, f);
        this._hashingStrategy = this;
    }

    public TFloatHash(TFloatHashingStrategy tFloatHashingStrategy) {
        this._hashingStrategy = tFloatHashingStrategy;
    }

    public TFloatHash(int n, TFloatHashingStrategy tFloatHashingStrategy) {
        super(n);
        this._hashingStrategy = tFloatHashingStrategy;
    }

    public TFloatHash(int n, float f, TFloatHashingStrategy tFloatHashingStrategy) {
        super(n, f);
        this._hashingStrategy = tFloatHashingStrategy;
    }

    public Object clone() {
        TFloatHash tFloatHash = (TFloatHash)super.clone();
        tFloatHash._set = (float[])this._set.clone();
        return tFloatHash;
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._set = new float[n2];
        return n2;
    }

    public boolean contains(float f) {
        return this.index(f) >= 0;
    }

    public boolean forEach(TFloatProcedure tFloatProcedure) {
        byte[] byArray = this._states;
        float[] fArray = this._set;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tFloatProcedure.execute(fArray[n])) continue;
            return false;
        }
        return true;
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._set[n] = 0.0f;
    }

    protected int index(float f) {
        byte[] byArray = this._states;
        float[] fArray = this._set;
        int n = byArray.length;
        int n2 = this._hashingStrategy.computeHashCode(f) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        if (byArray[n3] != 0 && (byArray[n3] == 2 || fArray[n3] != f)) {
            int n4 = 1 + n2 % (n - 2);
            do {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            } while (byArray[n3] != 0 && (byArray[n3] == 2 || fArray[n3] != f));
        }
        return byArray[n3] == 0 ? -1 : n3;
    }

    protected int insertionIndex(float f) {
        byte[] byArray = this._states;
        float[] fArray = this._set;
        int n = byArray.length;
        int n2 = this._hashingStrategy.computeHashCode(f) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        if (byArray[n3] == 0) {
            return n3;
        }
        if (byArray[n3] == 1 && fArray[n3] == f) {
            return -n3 - 1;
        }
        int n4 = 1 + n2 % (n - 2);
        if (byArray[n3] != 2) {
            do {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            } while (byArray[n3] == 1 && fArray[n3] != f);
        }
        if (byArray[n3] == 2) {
            int n5 = n3;
            while (byArray[n3] != 0 && (byArray[n3] == 2 || fArray[n3] != f)) {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            }
            return byArray[n3] == 1 ? -n3 - 1 : n5;
        }
        return byArray[n3] == 1 ? -n3 - 1 : n3;
    }

    public final int computeHashCode(float f) {
        return HashFunctions.hash(f);
    }
}

