/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TFloatFunction;
import gnu.trove.TFloatProcedure;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class TFloatArrayList
implements Serializable,
Cloneable {
    protected float[] _data;
    protected int _pos;
    protected static final int DEFAULT_CAPACITY = 10;

    public TFloatArrayList() {
        this(10);
    }

    public TFloatArrayList(int n) {
        this._data = new float[n];
        this._pos = 0;
    }

    public TFloatArrayList(float[] fArray) {
        this(Math.max(fArray.length, 10));
        this.add(fArray);
    }

    public void ensureCapacity(int n) {
        if (n > this._data.length) {
            int n2 = Math.max(this._data.length << 1, n);
            float[] fArray = new float[n2];
            System.arraycopy(this._data, 0, fArray, 0, this._data.length);
            this._data = fArray;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data.length > this.size()) {
            float[] fArray = new float[this.size()];
            this.toNativeArray(fArray, 0, fArray.length);
            this._data = fArray;
        }
    }

    public void add(float f) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = f;
    }

    public void add(float[] fArray) {
        this.add(fArray, 0, fArray.length);
    }

    public void add(float[] fArray, int n, int n2) {
        this.ensureCapacity(this._pos + n2);
        System.arraycopy(fArray, n, this._data, this._pos, n2);
        this._pos += n2;
    }

    public void insert(int n, float f) {
        if (n == this._pos) {
            this.add(f);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, n, this._data, n + 1, this._pos - n);
        this._data[n] = f;
        ++this._pos;
    }

    public void insert(int n, float[] fArray) {
        this.insert(n, fArray, 0, fArray.length);
    }

    public void insert(int n, float[] fArray, int n2, int n3) {
        if (n == this._pos) {
            this.add(fArray, n2, n3);
            return;
        }
        this.ensureCapacity(this._pos + n3);
        System.arraycopy(this._data, n, this._data, n + n3, this._pos - n);
        System.arraycopy(fArray, n2, this._data, n, n3);
        this._pos += n3;
    }

    public float get(int n) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this._data[n];
    }

    public float getQuick(int n) {
        return this._data[n];
    }

    public void set(int n, float f) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this._data[n] = f;
    }

    public float getSet(int n, float f) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        float f2 = this._data[n];
        this._data[n] = f;
        return f2;
    }

    public void set(int n, float[] fArray) {
        this.set(n, fArray, 0, fArray.length);
    }

    public void set(int n, float[] fArray, int n2, int n3) {
        if (n < 0 || n + n3 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        System.arraycopy(fArray, n2, this._data, n, n3);
    }

    public void setQuick(int n, float f) {
        this._data[n] = f;
    }

    public void clear() {
        this.clear(10);
    }

    public void clear(int n) {
        this._data = new float[n];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
        this.fill(0.0f);
    }

    public void resetQuick() {
        this._pos = 0;
    }

    public float remove(int n) {
        float f = this.get(n);
        this.remove(n, 1);
        return f;
    }

    public void remove(int n, int n2) {
        if (n < 0 || n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n == 0) {
            System.arraycopy(this._data, n2, this._data, 0, this._pos - n2);
        } else if (this._pos - n2 != n) {
            System.arraycopy(this._data, n + n2, this._data, n, this._pos - (n + n2));
        }
        this._pos -= n2;
    }

    public void transformValues(TFloatFunction tFloatFunction) {
        int n = this._pos;
        while (n-- > 0) {
            this._data[n] = tFloatFunction.execute(this._data[n]);
        }
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (n > n2) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int n3 = n;
        for (int i = n2 - 1; n3 < i; ++n3, --i) {
            this.swap(n3, i);
        }
    }

    public void shuffle(Random random) {
        int n = this._pos;
        while (n-- > 1) {
            this.swap(n, random.nextInt(n));
        }
    }

    private final void swap(int n, int n2) {
        float f = this._data[n];
        this._data[n] = this._data[n2];
        this._data[n2] = f;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public float[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public float[] toNativeArray(int n, int n2) {
        float[] fArray = new float[n2];
        this.toNativeArray(fArray, n, n2);
        return fArray;
    }

    public void toNativeArray(float[] fArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        System.arraycopy(this._data, 0, fArray, n, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TFloatArrayList) {
            TFloatArrayList tFloatArrayList = (TFloatArrayList)object;
            if (tFloatArrayList.size() != this.size()) {
                return false;
            }
            int n = this._pos;
            while (n-- > 0) {
                if (this._data[n] == tFloatArrayList._data[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this._pos;
        while (n2-- > 0) {
            n += HashFunctions.hash(this._data[n2]);
        }
        return n;
    }

    public boolean forEach(TFloatProcedure tFloatProcedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (tFloatProcedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachDescending(TFloatProcedure tFloatProcedure) {
        int n = this._pos;
        while (n-- > 0) {
            if (tFloatProcedure.execute(this._data[n])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        Arrays.sort(this._data, 0, this._pos);
    }

    public void sort(int n, int n2) {
        Arrays.sort(this._data, n, n2);
    }

    public void fill(float f) {
        Arrays.fill(this._data, 0, this._pos, f);
    }

    public void fill(int n, int n2, float f) {
        if (n2 > this._pos) {
            this.ensureCapacity(n2);
            this._pos = n2;
        }
        Arrays.fill(this._data, n, n2, f);
    }

    public int binarySearch(float f) {
        return this.binarySearch(f, 0, this._pos);
    }

    public int binarySearch(float f, int n, int n2) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n2 > this._pos) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >> 1;
            float f2 = this._data[n5];
            if (f2 < f) {
                n3 = n5 + 1;
                continue;
            }
            if (f2 > f) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public int indexOf(float f) {
        return this.indexOf(0, f);
    }

    public int indexOf(int n, float f) {
        for (int i = n; i < this._pos; ++i) {
            if (this._data[i] != f) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(float f) {
        return this.lastIndexOf(this._pos, f);
    }

    public int lastIndexOf(int n, float f) {
        int n2 = n;
        while (n2-- > 0) {
            if (this._data[n2] != f) continue;
            return n2;
        }
        return -1;
    }

    public boolean contains(float f) {
        return this.lastIndexOf(f) >= 0;
    }

    public TFloatArrayList grep(TFloatProcedure tFloatProcedure) {
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (!tFloatProcedure.execute(this._data[i])) continue;
            tFloatArrayList.add(this._data[i]);
        }
        return tFloatArrayList;
    }

    public TFloatArrayList inverseGrep(TFloatProcedure tFloatProcedure) {
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (tFloatProcedure.execute(this._data[i])) continue;
            tFloatArrayList.add(this._data[i]);
        }
        return tFloatArrayList;
    }

    public float max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        float f = this._data[this._pos - 1];
        int n = this._pos - 1;
        while (n-- > 0) {
            if (!(this._data[n] > f)) continue;
            f = this._data[n];
        }
        return f;
    }

    public float min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        float f = this._data[this._pos - 1];
        int n = this._pos - 1;
        while (n-- > 0) {
            if (!(this._data[n] < f)) continue;
            f = this._data[n];
        }
        return f;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = this._pos - 1;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this._data[i]);
            stringBuffer.append(", ");
        }
        if (this.size() > 0) {
            stringBuffer.append(this._data[this._pos - 1]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

