/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.vmware.api;

import com.tripwire.vmware.api.Properties;
import com.tripwire.vmware.api.ServiceInstance;
import com.tripwire.vmware.api.Util;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;

public class ManagedObject {
    private final ServiceInstance m_service;
    private final ManagedObjectReference m_reference;
    private final DynamicProperty[] m_properties;

    public ManagedObject(ServiceInstance service, ManagedObjectReference object) {
        this.m_service = service;
        this.m_reference = object;
        this.m_properties = new DynamicProperty[0];
    }

    public ManagedObject(ServiceInstance service, ObjectContent object) {
        this.m_service = service;
        this.m_reference = object.getObj();
        this.m_properties = object.getPropSet();
    }

    public DynamicProperty getProperty(String name) throws Exception {
        DynamicProperty property = Properties.getProperty(this.getProperties(), name);
        if (property != null) {
            return property;
        }
        return this.retrieveProperty(name);
    }

    public DynamicProperty retrieveProperty(String name) throws Exception {
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(this.m_reference);
        objectSpec.setSkip(Boolean.FALSE);
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.setType(this.m_reference.getType());
        propertySpec.setPathSet(new String[]{name});
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.setPropSet(new PropertySpec[]{propertySpec});
        propertyFilterSpec.setObjectSet(new ObjectSpec[]{objectSpec});
        ObjectContent[] contents = this.m_service.retrieveProperties(new PropertyFilterSpec[]{propertyFilterSpec});
        Util.validateOne(contents.length);
        ObjectContent content = contents[0];
        DynamicProperty[] properties = content.getPropSet();
        Util.validateOne(properties.length);
        DynamicProperty property = properties[0];
        Properties.addProperty(this.getProperties(), property);
        return property;
    }

    public DynamicProperty[] getProperties() {
        return this.m_properties;
    }
}

