/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional.xml;

import com.tripwire.common.util.ResourceManager;
import com.tripwire.common.util.xml.AbstractXmlElementParser;
import com.tripwire.common.util.xml.XmlException;
import com.tripwire.common.util.xml.XmlInputContext;
import com.tripwire.space.core.conditional.Conditional;
import com.tripwire.space.core.conditional.ConditionalList;
import com.tripwire.space.core.conditional.xml.ConditionalListXmlConstants;
import com.tripwire.space.core.conditional.xml.ConditionalPredicateXmlConstants;
import java.io.IOException;

public abstract class ConditionalListXmlElementParser
extends AbstractXmlElementParser
implements ConditionalListXmlConstants {
    public ConditionalListXmlElementParser(Class clazz) {
        super(COND_LIST_ELEMENT, clazz);
    }

    protected void readBody(XmlInputContext in, Object obj) throws XmlException, IOException {
        super.readBody(in, obj);
        ConditionalList cList = (ConditionalList)obj;
        while (in.detectElementStart(COND_LIST_ELEMENT) || in.detectElementStart(ConditionalPredicateXmlConstants.CONDITIONAL_PREDICATE_ELEMENT)) {
            cList.add((Conditional)in.maybeParseObjectElement());
        }
    }

    protected Object createInstanceAndReadAttributes(XmlInputContext in) throws XmlException {
        String operator = in.getStringAttribute(COND_LIST_TYPE_ATTRIBUTE, true);
        ConditionalList cList = null;
        if (operator.equalsIgnoreCase("AND")) {
            cList = ConditionalList.createAndList();
        } else if (operator.equalsIgnoreCase("OR")) {
            cList = ConditionalList.createOrList();
        } else {
            throw new XmlException(ResourceManager.getInstance().getSafeString("com.tripwire.space.core.conditional.conditionListXmlParserCreateError", new Object[]{operator}));
        }
        return cList;
    }

    public static class OrConditionsXmlElementParser
    extends ConditionalListXmlElementParser {
        public OrConditionsXmlElementParser() {
            super(ConditionalList.OrConditions.class);
        }
    }

    public static class AndConditionsXmlElementParser
    extends ConditionalListXmlElementParser {
        public AndConditionsXmlElementParser() {
            super(ConditionalList.AndConditions.class);
        }
    }
}

