/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional.operator;

import com.tripwire.space.core.conditional.operator.BetweenOperator;
import com.tripwire.space.core.conditional.operator.ContainOperator;
import com.tripwire.space.core.conditional.operator.EqualOperator;
import com.tripwire.space.core.conditional.operator.ExistOperator;
import com.tripwire.space.core.conditional.operator.GreaterEqualOperator;
import com.tripwire.space.core.conditional.operator.GreaterOperator;
import com.tripwire.space.core.conditional.operator.InOperator;
import com.tripwire.space.core.conditional.operator.LessEqualOperator;
import com.tripwire.space.core.conditional.operator.LessOperator;
import com.tripwire.space.core.conditional.operator.MatchOperator;
import com.tripwire.space.core.conditional.operator.Operator;
import gnu.trove.TIntObjectHashMap;

public class OperatorRepository {
    protected static final boolean CASE_SENSITIVE = true;
    protected static final boolean CASE_INSENSITIVE = false;
    private static final TIntObjectHashMap OPERATORS = new TIntObjectHashMap();
    private static final int NEGATE = -20;

    private static void put(Operator op) {
        OPERATORS.put(op.getId(), op);
    }

    public static Operator get(int type) {
        return (Operator)OPERATORS.get(type);
    }

    static {
        OperatorRepository.put(new BetweenOperator(true));
        OperatorRepository.put(new BetweenOperator(false));
        OperatorRepository.put(new EqualOperator(true));
        OperatorRepository.put(new EqualOperator(false));
        OperatorRepository.put(new ExistOperator());
        OperatorRepository.put(new GreaterOperator());
        OperatorRepository.put(new GreaterEqualOperator());
        OperatorRepository.put(new InOperator(true));
        OperatorRepository.put(new InOperator(false));
        OperatorRepository.put(new LessOperator());
        OperatorRepository.put(new LessEqualOperator());
        OperatorRepository.put(new MatchOperator());
        OperatorRepository.put(new ContainOperator());
    }
}

