/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional.operator;

import com.tripwire.space.core.conditional.operator.AbstractNumericalOperator;
import com.tripwire.space.core.conditional.operator.BinaryOperator;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.util.List;

public class EqualOperator
extends BinaryOperator {
    private static final TObjectHashingStrategy CI_STRATEGY = new TObjectHashingStrategy(){

        public int computeHashCode(Object o) {
            if (o instanceof String) {
                return ((String)o).toLowerCase().hashCode();
            }
            return o.hashCode();
        }

        public boolean equals(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            if (o1 instanceof String && o2 instanceof String) {
                return ((String)o1).equalsIgnoreCase((String)o2);
            }
            return o1.equals(o2);
        }
    };
    private boolean m_caseSensitive;

    EqualOperator() {
        this(true);
    }

    EqualOperator(boolean caseSensitive) {
        this.m_caseSensitive = caseSensitive;
    }

    public int getId() {
        return this.m_caseSensitive ? 0 : 10;
    }

    public boolean evaluate(Object operand, Object value) {
        if (operand == null) {
            return value == null;
        }
        if (value == null) {
            return false;
        }
        if (operand instanceof List && value instanceof List) {
            return this.evaluate((List)operand, (List)value);
        }
        if (operand instanceof String && value instanceof String) {
            String lhs = (String)operand;
            String rhs = (String)value;
            return this.m_caseSensitive ? lhs.equals(rhs) : lhs.equalsIgnoreCase(rhs);
        }
        Object lhs = operand;
        Object rhs = value;
        if (value instanceof Number) {
            if (operand instanceof String || operand instanceof Number) {
                long number = AbstractNumericalOperator.toLong(operand);
                return number == ((Number)value).longValue();
            }
        } else if (operand instanceof Number && (value instanceof String || value instanceof Number)) {
            long number = AbstractNumericalOperator.toLong(value);
            return number == ((Number)operand).longValue();
        }
        return lhs.equals(rhs);
    }

    public boolean evaluate(List operand, List value) {
        if (operand == null) {
            return value == null;
        }
        if (value == null) {
            return false;
        }
        if (operand.size() != value.size()) {
            return false;
        }
        TObjectIntHashMap hash = this.m_caseSensitive ? new TObjectIntHashMap(operand.size()) : new TObjectIntHashMap(operand.size(), CI_STRATEGY);
        for (Object obj : operand) {
            if (hash.containsKey(obj)) {
                int count = hash.get(obj);
                hash.put(obj, count + 1);
                continue;
            }
            hash.put(obj, 1);
        }
        for (Object val : value) {
            if (!hash.containsKey(val)) {
                return false;
            }
            int cnt = hash.get(val);
            if (cnt == 1) {
                hash.remove(val);
                continue;
            }
            hash.put(val, cnt - 1);
        }
        return hash.isEmpty();
    }
}

