/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional;

import com.tripwire.common.util.Regex;
import java.util.regex.Pattern;

public abstract class PropertyPatternFactory {
    protected static final int DEFAULT_REGEX_FLAGS = 40;
    protected static final PropertyPatternFactory[] FACTORIES = new PropertyPatternFactory[]{new JavaPropertyPatternFactory(), new IniPropertyPatternFactory()};
    private char m_commentsChar;
    private char m_separator;

    private PropertyPatternFactory(char commentsChar, char separator) {
        this.m_commentsChar = commentsChar;
        this.m_separator = separator;
    }

    private static int index(int style) {
        int index;
        switch (style) {
            case 3: {
                index = 0;
                break;
            }
            case 4: {
                index = 1;
                break;
            }
            default: {
                index = -1;
            }
        }
        return index;
    }

    public static Pattern createPattern(int style, String property) {
        int index = PropertyPatternFactory.index(style);
        return index < 0 ? null : FACTORIES[index].createPattern(property);
    }

    public static Pattern createPattern(int style, String section, String property) {
        int index = PropertyPatternFactory.index(style);
        return index < 0 ? null : FACTORIES[index].createPattern(section, property);
    }

    protected Pattern createPattern(String property) {
        StringBuffer regex = this.appendPropertyRegex(new StringBuffer(), property);
        return Regex.getPattern(regex.toString(), 40);
    }

    protected abstract Pattern createPattern(String var1, String var2);

    protected StringBuffer appendPropertyRegex(StringBuffer regex, String property) {
        regex.append("^\\s*");
        this.appendEscape(regex, property).append("\\s*");
        regex.append(this.m_separator).append("\\s*([^\\r\\n\\f");
        regex.append(this.m_commentsChar).append("]*)");
        return regex;
    }

    protected StringBuffer appendEscape(StringBuffer sb, String str) {
        if (str == null || str.length() == 0) {
            return sb;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
        return sb;
    }

    static class IniPropertyPatternFactory
    extends PropertyPatternFactory {
        IniPropertyPatternFactory() {
            super(';', '=');
        }

        public Pattern createPattern(String section, String property) {
            StringBuffer regex = new StringBuffer("^\\s*\\[");
            this.appendEscape(regex, section).append("\\].*?");
            this.appendPropertyRegex(regex, property);
            return Regex.getPattern(regex.toString(), 40);
        }
    }

    static class JavaPropertyPatternFactory
    extends PropertyPatternFactory {
        JavaPropertyPatternFactory() {
            super('#', '=');
        }

        public Pattern createPattern(String section, String property) {
            throw new UnsupportedOperationException();
        }
    }
}

