/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.ipdevice;

import com.mindbright.ssh.SSHClient;
import com.mindbright.ssh.SSHInteractorAdapter;
import com.tripwire.common.util.Dbg;
import com.tripwire.ipdevice.ResourceLoader;
import com.tripwire.ipdevice.SSHFailureReporter;
import com.tripwire.ipdevice.SSHUtil;

class SSHInteractor
extends SSHInteractorAdapter {
    SSHFailureReporter m_reporter;

    SSHInteractor() {
    }

    public void alert(String msg) {
        if (SSHUtil.DEBUG_ON) {
            Dbg.trace("SSH protocol alert: " + msg);
        }
        if (this.m_reporter != null) {
            if (msg.indexOf("permission denied") != -1) {
                this.m_reporter.reportFailure(2, msg);
            } else if (msg.indexOf("Connection refused") != -1) {
                this.m_reporter.reportFailure(1, msg);
            } else if (msg.indexOf("doesn't support ssh1") != -1) {
                this.m_reporter.reportFailure(3, msg);
            } else if (msg.indexOf("does not support the '") != -1) {
                int idx1 = msg.indexOf("does not support the '");
                int idx2 = msg.indexOf("' cipher");
                if (idx1 != -1 && idx2 != -1 && idx2 > idx1) {
                    this.m_reporter.reportFailure(4, msg);
                }
            } else if (msg.indexOf("Error connecting:") != -1) {
                this.m_reporter.reportFailure(5, msg);
            }
        }
    }

    public void connected(SSHClient client) {
        if (SSHUtil.DEBUG_ON) {
            Dbg.trace("Connected via SSH to " + client.getServerAddr());
        }
    }

    public void disconnected(SSHClient client, boolean graceful) {
        if (SSHUtil.DEBUG_ON) {
            Dbg.trace("Disconnected " + (graceful ? "gracefully" : "ungracefully") + " from " + client.getServerAddr());
        }
    }

    public void open(SSHClient client) {
        if (SSHUtil.DEBUG_ON) {
            Dbg.trace("Opened SSH connection to " + client.getServerAddr());
        }
    }

    public void report(String msg) {
        if (SSHUtil.DEBUG_ON) {
            Dbg.trace("SSH protocol report: " + msg);
        }
    }

    public void sessionStarted(SSHClient client) {
        if (SSHUtil.DEBUG_ON) {
            Dbg.trace("SSH session has started");
        }
    }

    public void setFailureReporter(SSHFailureReporter reporter) {
        this.m_reporter = reporter;
    }

    public void startNewSession(SSHClient client) {
        if (SSHUtil.DEBUG_ON) {
            Dbg.trace("Started new SSH session");
        }
    }

    static {
        ResourceLoader.load();
    }
}

