/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.ipdevice;

import com.tripwire.common.util.Dbg;
import com.tripwire.ipdevice.TraceWriter;
import com.tripwire.space.core.SpaceException;

public abstract class ExternalChannel {
    private TraceWriter m_writer;

    public abstract void setReadTimeout(long var1);

    public abstract void close() throws SpaceException;

    public abstract String[] read() throws SpaceException;

    public abstract String readLine() throws SpaceException;

    public abstract void write(String var1, boolean var2) throws SpaceException;

    public TraceWriter getTraceWriter() {
        return this.m_writer;
    }

    public void setTraceWriter(TraceWriter writer) {
        this.m_writer = writer;
    }

    public void traceRead(String s) {
        TraceWriter writer = this.m_writer;
        if (writer != null) {
            writer.writeStart("recv: ");
            writer.write(s);
            writer.write("\n");
        } else if (Dbg.TRACE) {
            Dbg.trace("-----recv: " + s + '\n');
        }
    }

    public void traceWrite(String s) {
        TraceWriter writer = this.m_writer;
        if (writer != null) {
            writer.writeStart("send: ");
            writer.write(s);
            if (s.length() > 0 && s.charAt(s.length() - 1) != '\n') {
                writer.write("\n");
            }
        } else if (Dbg.TRACE) {
            String sLine = "send: " + s;
            if (sLine.charAt(sLine.length() - 1) != '\n') {
                sLine = sLine + '\n';
            }
            Dbg.trace("-----" + sLine);
        }
    }
}

