/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.honeybee.ui.util;

import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class JOutputPane
extends JTextPane {
    public static final int TEXT_STYLE_NORMAL = 0;
    public static final int TEXT_STYLE_BOLD = 1;
    public static final int TEXT_STYLE_GOOD = 2;
    public static final int TEXT_STYLE_BAD = 3;

    public JOutputPane() {
        super(new DefaultStyledDocument());
    }

    public void appendText(String text, int style) {
        try {
            this.getDocument().insertString(this.getDocument().getLength(), text, this.getStyle(style));
        }
        catch (BadLocationException e) {
            throw new IllegalStateException();
        }
    }

    public void clear() {
        try {
            this.getDocument().remove(0, this.getDocument().getLength());
        }
        catch (BadLocationException e) {
            throw new IllegalStateException();
        }
    }

    private Style getStyle(int style) {
        if (this.getStyle("normal") == null) {
            Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
            Style normalStyle = this.addStyle("normal", defaultStyle);
            Style boldStyle = this.addStyle("bold", normalStyle);
            StyleConstants.setBold(boldStyle, true);
            Style goodStyle = this.addStyle("good", normalStyle);
            StyleConstants.setForeground(goodStyle, Color.green.darker());
            StyleConstants.setBold(goodStyle, true);
            Style badStyle = this.addStyle("bad", normalStyle);
            StyleConstants.setForeground(badStyle, Color.red.darker());
            StyleConstants.setBold(badStyle, true);
            this.addStyle("bad", badStyle);
        }
        switch (style) {
            case 0: {
                return this.getStyle("normal");
            }
            case 1: {
                return this.getStyle("bold");
            }
            case 2: {
                return this.getStyle("good");
            }
            case 3: {
                return this.getStyle("bad");
            }
        }
        throw new IllegalStateException();
    }
}

