/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.honeybee.ui.util;

import java.io.File;
import java.io.IOException;

public class BrowserLauncher {
    public static void openURL(String url) throws IOException {
        boolean success = false;
        String[][] browsers = BrowserLauncher.getBrowsers();
        for (int i = 0; browsers != null && i < browsers.length; ++i) {
            try {
                String[] parameters = new String[browsers[i].length + 1];
                for (int j = 0; j < browsers[i].length; ++j) {
                    parameters[j] = browsers[i][j];
                }
                parameters[browsers[i].length] = url;
                Runtime.getRuntime().exec(parameters);
                success = true;
                break;
            }
            catch (IOException e) {
                continue;
            }
        }
        if (!success) {
            throw new IOException("Failed to locate browser executable");
        }
    }

    protected static String[][] getBrowsers() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.equals("windows nt") || osName.equals("windows 2000")) {
            String[] toTry = new String[]{"C:\\Program Files\\Plus!\\Microsoft Internet\\iexplore.exe", "C:\\Program Files\\Internet Explorer\\iexplore.exe", "D:\\Program Files\\Plus!\\Microsoft Internet\\iexplore.exe", "D:\\Program Files\\Internet Explorer\\iexplore.exe"};
            for (int i = 0; i < toTry.length; ++i) {
                if (!new File(toTry[i]).exists()) continue;
                return new String[][]{{toTry[i]}};
            }
            return null;
        }
        if (osName.startsWith("win")) {
            return new String[][]{{"rundll32.exe", "url.dll,FileProtocolHandler"}};
        }
        return new String[][]{{"firefox"}, {"mozilla"}, {"netscape"}};
    }
}

