/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.honeybee.ui.model.testrunner;

import com.tripwire.honeybee.ui.controller.RequestInfo;
import com.tripwire.honeybee.ui.model.HoneybeeModel;
import com.tripwire.honeybee.ui.model.ModelFactory;
import com.tripwire.honeybee.ui.model.UnknownModelException;
import com.tripwire.honeybee.ui.model.eula.EulaModel;
import com.tripwire.honeybee.ui.model.eula.ResourceBasedEulaModel;
import com.tripwire.honeybee.ui.model.marketing.MarketingCollateralModel;
import com.tripwire.honeybee.ui.model.marketing.MarketingCollateralModelImpl;
import com.tripwire.honeybee.ui.model.testrunner.ComplianceAssessmentModel;
import com.tripwire.honeybee.ui.model.testrunner.ComplianceAssessmentModelImpl;
import com.tripwire.honeybee.ui.model.testrunner.RealTestRunnerModel;

public class HoneybeeModelFactory
implements ModelFactory {
    protected String m_remoteUrl;

    public HoneybeeModelFactory(String remoteUrl) {
        this.m_remoteUrl = remoteUrl;
    }

    public HoneybeeModel createModel(String modelTypeName, RequestInfo requestInfo) throws UnknownModelException {
        if (modelTypeName.equals("TestRunnerDialogModel")) {
            return new RealTestRunnerModel((MarketingCollateralModel)this.createModel("MarketingCollateralModel", requestInfo), (ComplianceAssessmentModel)this.createModel("ComplianceAssessmentModel", requestInfo));
        }
        if (modelTypeName.equals("ResourceBasedEulaModel")) {
            return this.createEulaModel(requestInfo);
        }
        if (modelTypeName.equals("MarketingCollateralModel")) {
            return this.createMarketingCollateralModel(requestInfo);
        }
        if (modelTypeName.equals("ComplianceAssessmentModel")) {
            return this.createComplianceAssessmentModel(requestInfo);
        }
        throw new UnknownModelException(modelTypeName);
    }

    protected EulaModel createEulaModel(RequestInfo requestInfo) {
        return new ResourceBasedEulaModel();
    }

    protected MarketingCollateralModel createMarketingCollateralModel(RequestInfo requestInfo) {
        return new MarketingCollateralModelImpl(this.m_remoteUrl);
    }

    protected ComplianceAssessmentModel createComplianceAssessmentModel(RequestInfo requestInfo) {
        return new ComplianceAssessmentModelImpl();
    }
}

