/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.honeybee.ui.model.testrunner;

import com.tripwire.checker.app.AccessorResultType;
import com.tripwire.checker.app.ConfigChecker;
import com.tripwire.checker.app.Test;
import com.tripwire.checker.app.TestResultType;
import com.tripwire.checker.app.xml.ContentTest;
import com.tripwire.checker.app.xml.PolicyTest;
import com.tripwire.checker.common.CheckerException;
import com.tripwire.checker.common.ConfigCheckerListener;
import com.tripwire.honeybee.ui.model.testrunner.ComplianceAssessmentModel;
import com.tripwire.honeybee.ui.model.testrunner.PolicyTree;
import com.tripwire.vmware.api.EsxServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplianceAssessmentModelImpl
implements ComplianceAssessmentModel,
ConfigCheckerListener {
    protected String m_hostname = "";
    protected String m_username = "";
    protected String m_password = "";
    protected String m_rootPassword;
    protected int m_errors;
    protected int m_passed;
    protected int m_failed;
    protected int m_pending;
    protected int m_unavailable;
    protected PolicyTree m_policyTree;
    protected ConfigCheckerListener m_eventCallback = null;

    @Override
    public String getHostname() {
        return this.m_hostname;
    }

    @Override
    public void setHostname(String hostname) {
        this.m_hostname = hostname;
    }

    @Override
    public String getUsername() {
        return this.m_username;
    }

    @Override
    public void setUsername(String username) {
        this.m_username = username;
    }

    @Override
    public String getPassword() {
        return this.m_password;
    }

    @Override
    public void setPassword(String password) {
        this.m_password = password;
    }

    @Override
    public String getRootPassword() {
        return this.m_rootPassword;
    }

    @Override
    public void setRootPassword(String rootPassword) {
        this.m_rootPassword = rootPassword;
    }

    private File getFile() {
        return new File(System.getProperty("user.home"), "honeybee.properties");
    }

    public void load() {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(this.getFile()));
            this.m_hostname = props.getProperty("hostname");
            this.m_username = props.getProperty("username");
        }
        catch (IOException e) {
            this.m_password = "";
            this.m_username = "";
            this.m_hostname = "";
        }
    }

    @Override
    public int getPendingCount() {
        return this.m_pending;
    }

    @Override
    public int getPassedCount() {
        return this.m_passed;
    }

    @Override
    public int getFailedCount() {
        return this.m_failed;
    }

    @Override
    public int getErrorCount() {
        return this.m_errors;
    }

    @Override
    public int getUnavailableCount() {
        return this.m_unavailable;
    }

    @Override
    public PolicyTree getPolicyTree() {
        return this.m_policyTree;
    }

    @Override
    public void onStart(String policyFile) {
        this.m_eventCallback.onStart(policyFile);
    }

    @Override
    public synchronized void onTestsLoaded(HashMap<String, PolicyTest> tests) {
        this.m_policyTree = new PolicyTree(tests);
        this.m_policyTree.walkTree(new PolicyTree.TreeProcessor(){

            public void onReceiveNode(PolicyTree.PolicyTreeNode treeNode) {
                if (treeNode.leaf) {
                    ++ComplianceAssessmentModelImpl.this.m_pending;
                }
            }
        });
        this.m_eventCallback.onTestsLoaded(tests);
    }

    @Override
    public synchronized void onChangeTest(ContentTest test, TestResultType newResult, TestResultType oldResult) {
        switch (newResult) {
            case UNAVAILABLE: {
                --this.m_pending;
                ++this.m_unavailable;
                break;
            }
            case ERROR: {
                --this.m_pending;
                ++this.m_errors;
                break;
            }
            case FAIL: {
                --this.m_pending;
                ++this.m_failed;
                break;
            }
            case PASS: {
                --this.m_pending;
                ++this.m_passed;
                break;
            }
            default: {
                return;
            }
        }
        this.m_eventCallback.onChangeTest(test, newResult, oldResult);
    }

    @Override
    public synchronized void onTestError(Test test, CheckerException error) {
        this.m_eventCallback.onTestError(test, error);
    }

    @Override
    public synchronized void onFatalError(CheckerException error) {
        this.m_eventCallback.onFatalError(error);
    }

    @Override
    public void onGeneralError(CheckerException error) {
        this.m_eventCallback.onGeneralError(error);
    }

    @Override
    public synchronized void onVersionInfo(String uname, String vmware, EsxServer.Version version) {
        this.m_eventCallback.onVersionInfo(uname, vmware, version);
    }

    @Override
    public synchronized void onAccessorStart(String accessorType) {
        this.m_eventCallback.onAccessorStart(accessorType);
    }

    @Override
    public synchronized void onAccessorChange(String accessorType, AccessorResultType newResult, AccessorResultType oldResult) {
        this.m_eventCallback.onAccessorChange(accessorType, newResult, oldResult);
    }

    @Override
    public synchronized void onAccessorEnd(String accessorType, long timeTaken, AccessorResultType result, Exception e) {
        this.m_eventCallback.onAccessorEnd(accessorType, timeTaken, result, e);
    }

    @Override
    public synchronized void onEnd(long timeTaken) {
        this.m_pending = 0;
        this.m_eventCallback.onEnd(timeTaken);
    }

    public void save() {
        Properties props = new Properties();
        props.setProperty("hostname", this.m_hostname);
        props.setProperty("username", this.m_username);
        try {
            props.store(new FileOutputStream(this.getFile()), "Persistant Honeybee settings");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void startChecking(ConfigCheckerListener cb) {
        this.m_eventCallback = cb;
        this.m_errors = 0;
        this.m_unavailable = 0;
        this.m_pending = 0;
        this.m_passed = 0;
        this.m_failed = 0;
        String host = this.getHostname();
        String username = this.getUsername();
        String password = this.getPassword();
        String rootPassword = this.getRootPassword();
        if (host == null || host.length() == 0 || username == null || username.length() == 0 || password == null || password.length() == 0 || rootPassword == null || rootPassword.length() == 0) {
            ++this.m_errors;
            cb.onFatalError(new CheckerException("error.incompletLoginInfo.message"));
            return;
        }
        ConfigChecker runner = new ConfigChecker(host, username, password, rootPassword, this, "com/tripwire/checker/data/VMware_ESX_Server_v3.x_Security_TE_7.1_Policy.xml", "com/tripwire/checker/data/VMware_ESX_Server_v3.x_TE_7.1_Rules.xml", "com/tripwire/checker/data/VMware_ESX_Server_v3.5_Security_TE_7.1_Policy.xml", "com/tripwire/checker/data/VMware_ESX_Server_v3.5_TE_7.1_Policy_Rules.xml", "com/tripwire/checker/data/VMware_ESX_Server_Embedded_v3.x_Security_TE_7.1_Policy.xml");
        Thread runThread = new Thread(runner);
        runThread.start();
    }
}

