/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util.xml;

import com.tripwire.common.collections.CollectionTools;
import com.tripwire.common.util.xml.XmlAttributeName;
import com.tripwire.common.util.xml.XmlElementGenerator;
import com.tripwire.common.util.xml.XmlElementName;
import com.tripwire.common.util.xml.XmlException;
import com.tripwire.common.util.xml.XmlFilter;
import com.tripwire.common.util.xml.XmlFilterManager;
import com.tripwire.common.util.xml.XmlOutputFormat;
import com.tripwire.common.util.xml.XmlParserException;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class XmlOutputContext {
    public static final DateFormat XML_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.S Z");
    private final XmlSerializer m_output;
    private final Writer m_rawOutput;
    private final XmlOutputFormat m_format;
    private final Map m_identifiers = CollectionTools.createMap();
    private long m_highestIdentifier = -1L;
    private final Map m_storedObjects = CollectionTools.createMap();
    private Object m_target = null;
    private final XmlFilterManager m_filterManager = new XmlFilterManager();
    private final Map m_pending = CollectionTools.createMap();
    private int m_ignoreElementCount = 0;
    public static final XmlFilter ACCEPT_ALL_FILTER = new AcceptAllXmlFilter();

    public void addPending(Object object, Object owner) throws XmlException {
        if (owner == null || object == null) {
            return;
        }
        if (this.hasIdentifier(object)) {
            return;
        }
        this.createIdentifier(object);
        ArrayList<Object> pending = (ArrayList<Object>)this.m_pending.get(owner);
        if (pending == null) {
            pending = new ArrayList<Object>();
            this.m_pending.put(owner, pending);
        }
        pending.add(object);
    }

    private void writePending(Object owner) throws XmlException, IOException {
        List pending = (List)this.m_pending.get(owner);
        if (pending == null) {
            return;
        }
        for (Object child : pending) {
            this.writeObjectElement(child);
        }
        pending.clear();
    }

    public void finish(Object obj) throws XmlException, IOException {
        this.writePending(obj);
    }

    public XmlOutputContext(Writer output, XmlOutputFormat format) throws XmlException, IOException {
        assert (output != null);
        assert (format != null);
        this.m_format = format;
        try {
            this.m_rawOutput = output;
            String lineSeparator = System.getProperty("line.separator");
            this.m_output = XmlPullParserFactory.newInstance().newSerializer();
            this.m_output.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "    ");
            this.m_output.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", lineSeparator);
            this.m_output.setOutput(output);
            this.m_output.startDocument("UTF-8", null);
            this.m_output.ignorableWhitespace(lineSeparator);
        }
        catch (XmlPullParserException ex) {
            throw new XmlParserException(ex);
        }
    }

    public Object getTarget() {
        return this.m_target;
    }

    public void setTarget(Object target) {
        this.m_target = target;
    }

    public String getIdentifier(Object object) throws XmlException {
        String identifier = (String)this.m_identifiers.get(this.getIdentifierKey(object));
        return identifier == null ? this.createIdentifier(object) : identifier;
    }

    private String createIdentifier(Object object) throws XmlException {
        Object key = this.getIdentifierKey(object);
        assert (this.m_identifiers.get(key) == null);
        String identifier = "ID" + ++this.m_highestIdentifier;
        this.m_identifiers.put(key, identifier);
        return identifier;
    }

    public boolean hasIdentifier(Object obj) throws XmlException {
        return this.m_identifiers.containsKey(this.getIdentifierKey(obj));
    }

    protected Object getIdentifierKey(Object object) throws XmlException {
        return object;
    }

    public final void writeBooleanAttribute(XmlAttributeName attribute, boolean value) throws IOException {
        this.writeStringAttribute(attribute, Boolean.toString(value));
    }

    public final void writeIntegerAttribute(XmlAttributeName attribute, int value) throws IOException {
        assert (attribute != null);
        this.writeStringAttribute(attribute, Integer.toString(value));
    }

    public final void writeLongAttribute(XmlAttributeName attribute, long value) throws IOException {
        assert (attribute != null);
        this.writeStringAttribute(attribute, Long.toString(value));
    }

    public final void writeFloatAttribute(XmlAttributeName attribute, float value) throws IOException {
        assert (attribute != null);
        this.writeStringAttribute(attribute, Float.toString(value));
    }

    public final void writeStringAttribute(XmlAttributeName attribute, String value) throws IOException {
        assert (attribute != null);
        assert (value != null);
        assert (value.indexOf(10) < 0);
        assert (value.indexOf(13) < 0);
        if (this.acceptAttribute(attribute)) {
            this.m_output.attribute(attribute.getNamespace(), attribute.getName(), value);
        }
    }

    public final void writeElementStart(XmlElementName element) throws IOException {
        assert (element != null);
        if (this.getCurrentFilter().acceptChildElement(element)) {
            if (this.m_ignoreElementCount == 0) {
                this.m_output.startTag(element.getNamespace(), element.getName());
            }
        } else {
            ++this.m_ignoreElementCount;
        }
    }

    public final void writeElementEnd(XmlElementName element) throws IOException {
        assert (element != null);
        if (this.getCurrentFilter().acceptChildElement(element)) {
            if (this.m_ignoreElementCount == 0) {
                this.m_output.endTag(element.getNamespace(), element.getName());
            }
        } else {
            --this.m_ignoreElementCount;
        }
    }

    public final void writeText(String text) throws IOException {
        assert (text != null);
        if (this.acceptText()) {
            this.m_output.text(text);
        }
    }

    public final void writeRawXml(String text) throws IOException {
        assert (text != null);
        if (this.acceptText()) {
            this.m_output.text("");
            this.m_rawOutput.write(text);
        }
    }

    public final void writeBooleanElement(XmlElementName element, boolean value) throws IOException {
        assert (element != null);
        this.writeStringElement(element, Boolean.toString(value));
    }

    public final void writeIntegerElement(XmlElementName element, int value) throws IOException {
        assert (element != null);
        this.writeStringElement(element, Integer.toString(value));
    }

    public final void writeLongElement(XmlElementName element, long value) throws IOException {
        assert (element != null);
        this.writeStringElement(element, Long.toString(value));
    }

    public final void writeStringElement(XmlElementName element, String value) throws IOException {
        assert (element != null);
        assert (value != null);
        this.writeElementStart(element);
        if (this.acceptChildElement(element)) {
            this.writeText(value);
        }
        this.writeElementEnd(element);
    }

    public final void writeDateElement(XmlElementName element, Date value) throws IOException {
        assert (element != null);
        assert (value != null);
        this.writeElementStart(element);
        if (this.acceptChildElement(element)) {
            this.writeText(XML_DATE_FORMAT.format(value));
        }
        this.writeElementEnd(element);
    }

    public final void writeObjectElement(Object obj) throws XmlException, IOException {
        XmlElementGenerator generator = this.m_format.getGeneratorForClass(obj.getClass());
        generator.write(this, obj);
    }

    public final void writeObjectElementStart(Object obj) throws XmlException, IOException {
        XmlElementGenerator generator = this.m_format.getGeneratorForClass(obj.getClass());
        generator.writeStart(this, obj);
    }

    public final void writeObjectElementEnd(Object obj) throws XmlException, IOException {
        XmlElementGenerator generator = this.m_format.getGeneratorForClass(obj.getClass());
        generator.writeEnd(this, obj);
    }

    public void setObject(String name, Object value) {
        this.m_storedObjects.put(name, value);
    }

    public Object remove(String name) {
        return this.m_storedObjects.remove(name);
    }

    public Object getObject(String name) {
        return this.m_storedObjects.get(name);
    }

    public XmlFilterManager getFilterManager() {
        return this.m_filterManager;
    }

    public XmlFilter getCurrentFilter() {
        if (this.getTarget() == null) {
            return ACCEPT_ALL_FILTER;
        }
        return this.getFilterManager().getFilter(this.getTarget().getClass());
    }

    public XmlOutputFormat getFormat() {
        return this.m_format;
    }

    protected boolean acceptChildElement(XmlElementName name) {
        return this.m_ignoreElementCount == 0 && this.getCurrentFilter().acceptChildElement(name);
    }

    protected boolean acceptAttribute(XmlAttributeName name) {
        return this.m_ignoreElementCount == 0 && this.getCurrentFilter().acceptAttribute(name);
    }

    protected boolean acceptText() {
        return this.m_ignoreElementCount == 0;
    }

    private static final class AcceptAllXmlFilter
    implements XmlFilter {
        private AcceptAllXmlFilter() {
        }

        public boolean acceptAttribute(XmlAttributeName name) {
            return true;
        }

        public boolean acceptChildElement(XmlElementName name) {
            return true;
        }

        public boolean acceptText(XmlElementName name) {
            return true;
        }
    }
}

