/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util.xml;

public abstract class XmlName
implements Comparable {
    public static final String DEFAULT_NAMESPACE = "";
    private final String m_namespace;
    private final String m_name;

    public XmlName(String namespace, String name) {
        if (!XmlName.isValidXMLName(name)) {
            throw new IllegalArgumentException("Illegal name '" + name + "' passed to XmlName constructor");
        }
        this.m_name = name;
        this.m_namespace = namespace;
    }

    public static boolean isValidXMLName(String elementName) {
        if (elementName == null) {
            return false;
        }
        int length = elementName.length();
        if (length == 0) {
            return false;
        }
        char firstChar = elementName.charAt(0);
        if (!Character.isLetter(firstChar) && firstChar != '_' && firstChar != ':') {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char ch = elementName.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_' || ch == '-' || ch == '.' || ch == ':') continue;
            return false;
        }
        return true;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getName() {
        assert (XmlName.isValidXMLName(this.m_name));
        return this.m_name;
    }

    public abstract String getTypeOfName();

    public boolean equals(Object other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        XmlName otherName = (XmlName)other;
        return this.m_namespace.equals(otherName.getNamespace()) && this.m_name.equals(otherName.getName());
    }

    public int hashCode() {
        return this.m_namespace.hashCode() ^ this.m_name.hashCode();
    }

    public int compareTo(Object o) {
        return this.m_name.compareTo(o.toString());
    }

    public String toString() {
        return this.m_name;
    }
}

